/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.panel;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.panel.ComponentPanel;
import com.intellij.openapi.ui.panel.GridBagPanelBuilder;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.EditorTextComponent;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.function.Supplier;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentPanelBuilder
implements GridBagPanelBuilder {
    private final JComponent myComponent;
    private String myLabelText;
    private boolean myLabelOnTop;
    private String myCommentText;
    private HyperlinkListener myHyperlinkListener = BrowserHyperlinkListener.INSTANCE;
    private boolean myCommentBelow = true;
    private boolean myCommentAllowAutoWrapping = true;
    private String myHTDescription;
    private String myHTLinkText;
    private Runnable myHTAction;
    private JComponent myTopRightComponent;
    private UI.Anchor myAnchor = UI.Anchor.Center;
    private boolean myResizeY;
    private boolean myResizeX = true;
    private boolean valid = true;

    public ComponentPanelBuilder(JComponent component) {
        this.myComponent = component;
    }

    public ComponentPanelBuilder resizeY(boolean resize) {
        this.myResizeY = resize;
        return this;
    }

    public ComponentPanelBuilder resizeX(boolean resize) {
        this.myResizeX = resize;
        return this;
    }

    public ComponentPanelBuilder withLabel(@NotNull @NlsContexts.Label String labelText) {
        this.myLabelText = labelText;
        return this;
    }

    public ComponentPanelBuilder moveLabelOnTop() {
        this.myLabelOnTop = true;
        this.valid = StringUtil.isEmpty((String)this.myCommentText) || StringUtil.isEmpty((String)this.myHTDescription);
        return this;
    }

    public ComponentPanelBuilder anchorLabelOn(UI.Anchor anchor) {
        this.myAnchor = anchor;
        return this;
    }

    public ComponentPanelBuilder withComment(@NotNull @NlsContexts.DetailedDescription String comment) {
        return this.withComment(comment, true);
    }

    public ComponentPanelBuilder withComment(@NotNull @NlsContexts.DetailedDescription String comment, boolean allowAutoWrapping) {
        this.myCommentText = comment;
        this.myCommentAllowAutoWrapping = allowAutoWrapping;
        this.valid = StringUtil.isEmpty((String)comment) || StringUtil.isEmpty((String)this.myHTDescription);
        return this;
    }

    public ComponentPanelBuilder withCommentHyperlinkListener(@NotNull HyperlinkListener listener2) {
        this.myHyperlinkListener = listener2;
        return this;
    }

    public ComponentPanelBuilder withTopRightComponent(@NotNull JComponent topRightComponent) {
        this.myTopRightComponent = topRightComponent;
        this.valid = StringUtil.isEmpty((String)this.myCommentText) || StringUtil.isEmpty((String)this.myHTDescription);
        return this;
    }

    public ComponentPanelBuilder moveCommentRight() {
        this.myCommentBelow = false;
        return this;
    }

    public ComponentPanelBuilder withTooltip(@NotNull @NlsContexts.Tooltip String description) {
        this.myHTDescription = description;
        this.valid = StringUtil.isEmpty((String)this.myCommentText) || StringUtil.isEmpty((String)description);
        return this;
    }

    public ComponentPanelBuilder withTooltipLink(@NotNull @NlsContexts.LinkLabel String linkText, @NotNull Runnable action) {
        this.myHTLinkText = linkText;
        this.myHTAction = action;
        return this;
    }

    @Override
    @NotNull
    public JPanel createPanel() {
        NonOpaquePanel panel2 = new NonOpaquePanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 2, null, 0, 0);
        this.addToPanel(panel2, gc, false);
        return panel2;
    }

    @Override
    public boolean constrainsValid() {
        return this.valid;
    }

    @Override
    public int gridWidth() {
        return this.myCommentBelow ? 2 : (this.myResizeX ? 4 : 3);
    }

    @Override
    public void addToPanel(JPanel panel2, GridBagConstraints gc, boolean splitColumns) {
        if (this.constrainsValid()) {
            new ComponentPanelImpl(splitColumns).addToPanel(panel2, gc);
        }
    }

    private Border getCommentBorder() {
        if (StringUtil.isNotEmpty((String)this.myCommentText)) {
            return new JBEmptyBorder(ComponentPanelBuilder.computeCommentInsets(this.myComponent, this.myCommentBelow));
        }
        return JBUI.Borders.empty();
    }

    @NotNull
    public static Insets computeCommentInsets(@NotNull JComponent component, boolean commentBelow) {
        boolean isMacDefault = UIUtil.isUnderDefaultMacTheme();
        boolean isWin10 = UIUtil.isUnderWin10LookAndFeel();
        if (commentBelow) {
            int top = 8;
            int left = 2;
            int bottom = 0;
            if (component instanceof JRadioButton || component instanceof JCheckBox) {
                top = 0;
                int n = isWin10 ? 10 : (bottom = isMacDefault ? 8 : 9);
                if (component instanceof JCheckBox) {
                    left = UIUtil.getCheckBoxTextHorizontalOffset((JCheckBox)((JCheckBox)component));
                    return new Insets(top, left, JBUIScale.scale((int)bottom), 0);
                }
                left = isMacDefault ? 26 : (isWin10 ? 17 : 23);
            } else if (component instanceof JTextField || component instanceof EditorTextComponent || component instanceof JComboBox || component instanceof ComponentWithBrowseButton) {
                int n = top = isWin10 ? 3 : 4;
                int n2 = isWin10 ? 2 : (left = isMacDefault ? 5 : 4);
                bottom = isWin10 ? 10 : (isMacDefault ? 8 : 9);
            } else if (component instanceof JButton) {
                int n = top = isWin10 ? 2 : 4;
                left = isWin10 ? 2 : (isMacDefault ? 5 : 4);
                bottom = 0;
            }
            return JBUI.insets((int)top, (int)left, (int)bottom, (int)0);
        }
        int left = 14;
        if (component instanceof JRadioButton || component instanceof JCheckBox) {
            left = isMacDefault ? 8 : 13;
        } else if (component instanceof JTextField || component instanceof EditorTextComponent || component instanceof JComboBox || component instanceof ComponentWithBrowseButton) {
            left = isMacDefault ? 13 : 14;
        }
        return JBUI.insetsLeft((int)left);
    }

    @NotNull
    public static JLabel createCommentComponent(@Nullable @NlsContexts.DetailedDescription String commentText, boolean isCommentBelow) {
        return ComponentPanelBuilder.createCommentComponent(commentText, isCommentBelow, 70, true);
    }

    @NotNull
    public static JLabel createCommentComponent(@Nullable @NlsContexts.DetailedDescription String commentText, boolean isCommentBelow, int maxLineLength) {
        return ComponentPanelBuilder.createCommentComponent(commentText, isCommentBelow, maxLineLength, true);
    }

    @NotNull
    public static JLabel createCommentComponent(@Nullable @NlsContexts.DetailedDescription String commentText, boolean isCommentBelow, int maxLineLength, boolean allowAutoWrapping) {
        return ComponentPanelBuilder.createCommentComponent(() -> new JBLabel(""), commentText, isCommentBelow, maxLineLength, allowAutoWrapping);
    }

    private static JLabel createCommentComponent(@NotNull Supplier<? extends JBLabel> labelSupplier, @Nullable @NlsContexts.DetailedDescription String commentText, boolean isCommentBelow, int maxLineLength, boolean allowAutoWrapping) {
        boolean isCopyable = SystemProperties.getBooleanProperty((String)"idea.ui.comment.copyable", (boolean)true);
        JBLabel component = labelSupplier.get().setCopyable(isCopyable).setAllowAutoWrapping(allowAutoWrapping);
        ((JLabel)component).setVerticalTextPosition(1);
        ((Component)component).setFocusable(false);
        ((JComponent)component).setForeground(UIUtil.getContextHelpForeground());
        ComponentPanelBuilder.setCommentFont(component);
        if (isCopyable) {
            ComponentPanelBuilder.setCommentText(component, commentText, isCommentBelow, maxLineLength);
        } else {
            ((JLabel)component).setText(commentText);
        }
        return component;
    }

    public static JLabel createNonWrappingCommentComponent(@NotNull @NlsContexts.DetailedDescription String commentText) {
        JBLabel component = new JBLabel(commentText);
        component.setForeground(UIUtil.getContextHelpForeground());
        ComponentPanelBuilder.setCommentFont(component);
        return component;
    }

    private static void setCommentText(@NotNull JLabel component, @Nullable @NlsContexts.DetailedDescription String commentText, boolean isCommentBelow, int maxLineLength) {
        if (commentText != null) {
            String css = "<head><style type=\"text/css\">\na, a:link {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.linkColor()) + ";}\na:visited {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.linkVisitedColor()) + ";}\na:hover {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.linkHoverColor()) + ";}\na:active {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.linkPressedColor()) + ";}\n</style>\n</head>";
            if (maxLineLength > 0 && commentText.length() > maxLineLength && isCommentBelow) {
                int width = component.getFontMetrics(component.getFont()).stringWidth(commentText.substring(0, maxLineLength));
                component.setText(String.format("<html>" + css + "<body><div width=%d>%s</div></body></html>", width, commentText));
            } else {
                component.setText(String.format("<html>" + css + "<body><div>%s</div></body></html>", commentText));
            }
        }
    }

    private static void setCommentFont(@NotNull JLabel component) {
        if (SystemInfo.isMac) {
            Font font = component.getFont();
            float size = font.getSize2D();
            Font smallFont = font.deriveFont(size - 2.0f);
            component.setFont(smallFont);
        }
    }

    private class ComponentPanelImpl
    extends ComponentPanel {
        private final JLabel label;
        private final JLabel comment;
        private final boolean splitColumns;

        private ComponentPanelImpl(boolean splitColumns) {
            this.splitColumns = splitColumns;
            if (StringUtil.isNotEmpty((String)ComponentPanelBuilder.this.myLabelText)) {
                this.label = new JLabel();
                LabeledComponent.TextWithMnemonic.fromTextWithMnemonic(ComponentPanelBuilder.this.myLabelText).setToLabel(this.label);
                this.label.setLabelFor(ComponentPanelBuilder.this.myComponent);
            } else {
                this.label = new JLabel("");
            }
            this.comment = ComponentPanelBuilder.createCommentComponent(() -> new JBLabel(""){

                @Override
                @NotNull
                protected HyperlinkListener createHyperlinkListener() {
                    return ComponentPanelBuilder.this.myHyperlinkListener;
                }
            }, ComponentPanelBuilder.this.myCommentText, ComponentPanelBuilder.this.myCommentBelow, 70, ComponentPanelBuilder.this.myCommentAllowAutoWrapping);
            this.comment.setBorder(ComponentPanelBuilder.this.getCommentBorder());
        }

        @Override
        public String getCommentText() {
            return ComponentPanelBuilder.this.myCommentText;
        }

        @Override
        public void setCommentText(String commentText) {
            if (!StringUtil.equals((CharSequence)ComponentPanelBuilder.this.myCommentText, (CharSequence)commentText)) {
                ComponentPanelBuilder.this.myCommentText = commentText;
                this.setCommentTextImpl(commentText);
            }
        }

        private void setCommentTextImpl(String commentText) {
            ComponentPanelBuilder.setCommentText(this.comment, commentText, ComponentPanelBuilder.this.myCommentBelow, 70);
        }

        private void addToPanel(JPanel panel2, GridBagConstraints gc) {
            gc.gridx = 0;
            gc.gridwidth = 1;
            gc.weightx = 0.0;
            gc.anchor = 21;
            if (StringUtil.isNotEmpty((String)ComponentPanelBuilder.this.myLabelText)) {
                if (ComponentPanelBuilder.this.myLabelOnTop || ComponentPanelBuilder.this.myTopRightComponent != null) {
                    gc.insets = JBUI.insetsBottom((int)4);
                    gc.gridx = 1;
                    JPanel topPanel = new JPanel();
                    topPanel.setLayout(new BoxLayout(topPanel, 0));
                    if (ComponentPanelBuilder.this.myLabelOnTop) {
                        topPanel.add(this.label);
                    }
                    if (ComponentPanelBuilder.this.myTopRightComponent != null) {
                        topPanel.add(new Box.Filler((Dimension)JBUI.size((int)10, (int)0), (Dimension)JBUI.size((int)10, (int)0), (Dimension)JBUI.size((int)Integer.MAX_VALUE)));
                        topPanel.add(ComponentPanelBuilder.this.myTopRightComponent);
                    }
                    panel2.add((Component)topPanel, gc);
                    ++gc.gridy;
                }
                if (!ComponentPanelBuilder.this.myLabelOnTop) {
                    gc.gridx = 0;
                    switch (ComponentPanelBuilder.this.myAnchor) {
                        case Top: {
                            gc.anchor = 19;
                            gc.insets = JBUI.insets((int)4, (int)0, (int)0, (int)8);
                            break;
                        }
                        case Center: {
                            gc.anchor = 21;
                            gc.insets = JBUI.insetsRight((int)8);
                            break;
                        }
                        case Bottom: {
                            gc.anchor = 20;
                            gc.insets = JBUI.insets((int)0, (int)0, (int)4, (int)8);
                        }
                    }
                    panel2.add((Component)this.label, gc);
                }
            }
            gc.gridx = gc.gridx + (ComponentPanelBuilder.this.myLabelOnTop ? 0 : 1);
            gc.weightx = 1.0;
            gc.insets = JBUI.emptyInsets();
            gc.fill = ComponentPanelBuilder.this.myResizeY ? 1 : (ComponentPanelBuilder.this.myResizeX ? 2 : 0);
            double d = gc.weighty = ComponentPanelBuilder.this.myResizeY ? 1.0 : 0.0;
            if (this.splitColumns) {
                panel2.add((Component)ComponentPanelBuilder.this.myComponent, gc);
            }
            if (StringUtil.isNotEmpty((String)ComponentPanelBuilder.this.myHTDescription) || !ComponentPanelBuilder.this.myCommentBelow) {
                JPanel componentPanel = new JPanel();
                componentPanel.setLayout(new BoxLayout(componentPanel, 0));
                if (!this.splitColumns) {
                    componentPanel.add(ComponentPanelBuilder.this.myComponent);
                }
                if (StringUtil.isNotEmpty((String)ComponentPanelBuilder.this.myHTDescription)) {
                    ContextHelpLabel lbl = StringUtil.isNotEmpty((String)ComponentPanelBuilder.this.myHTLinkText) && ComponentPanelBuilder.this.myHTAction != null ? ContextHelpLabel.createWithLink(null, ComponentPanelBuilder.this.myHTDescription, ComponentPanelBuilder.this.myHTLinkText, ComponentPanelBuilder.this.myHTAction) : ContextHelpLabel.create(ComponentPanelBuilder.this.myHTDescription);
                    JBUI.Borders.emptyLeft((int)7).wrap((JComponent)lbl);
                    componentPanel.add(lbl);
                    ComponentValidator.getInstance(ComponentPanelBuilder.this.myComponent).ifPresent(v -> {
                        JLabel iconLabel = new JLabel();
                        JBUI.Borders.emptyLeft((int)7).wrap((JComponent)iconLabel);
                        iconLabel.setVisible(false);
                        componentPanel.add(iconLabel);
                        iconLabel.addMouseListener(new MouseAdapter(){

                            @Override
                            public void mouseEntered(MouseEvent e) {
                                ComponentPanelBuilder.this.myComponent.dispatchEvent(ComponentPanelImpl.this.convertMouseEvent(e));
                                e.consume();
                            }

                            @Override
                            public void mouseExited(MouseEvent e) {
                                ComponentPanelBuilder.this.myComponent.dispatchEvent(ComponentPanelImpl.this.convertMouseEvent(e));
                                e.consume();
                            }
                        });
                        ComponentPanelBuilder.this.myComponent.addPropertyChangeListener("JComponent.outline", evt -> {
                            if (evt.getNewValue() == null) {
                                iconLabel.setVisible(false);
                                lbl.setVisible(true);
                            } else if ("warning".equals(evt.getNewValue())) {
                                iconLabel.setIcon(AllIcons.General.BalloonWarning);
                                iconLabel.setVisible(true);
                                lbl.setVisible(false);
                            } else if ("error".equals(evt.getNewValue())) {
                                iconLabel.setIcon(AllIcons.General.BalloonError);
                                iconLabel.setVisible(true);
                                lbl.setVisible(false);
                            }
                            componentPanel.revalidate();
                            componentPanel.repaint();
                        });
                    });
                    panel2.add((Component)componentPanel, gc);
                } else if (!ComponentPanelBuilder.this.myCommentBelow) {
                    if (this.splitColumns) {
                        ++gc.gridx;
                        gc.weightx = 0.0;
                        gc.fill = 0;
                        gc.weighty = 0.0;
                        panel2.add((Component)this.comment, gc);
                    } else {
                        this.comment.setBorder(ComponentPanelBuilder.this.getCommentBorder());
                        componentPanel.add(this.comment);
                        panel2.add((Component)componentPanel, gc);
                    }
                }
            } else if (!this.splitColumns) {
                panel2.add((Component)ComponentPanelBuilder.this.myComponent, gc);
            }
            if (!this.splitColumns && !ComponentPanelBuilder.this.myResizeX) {
                ++gc.gridx;
                gc.weightx = 1.0;
                gc.fill = 0;
                panel2.add((Component)new JPanel(), gc);
            }
            gc.fill = 2;
            gc.weighty = 0.0;
            if (ComponentPanelBuilder.this.myCommentBelow) {
                gc.gridx = 1;
                ++gc.gridy;
                gc.weightx = 0.0;
                gc.anchor = 18;
                gc.insets = JBUI.emptyInsets();
                this.comment.setBorder(ComponentPanelBuilder.this.getCommentBorder());
                panel2.add((Component)this.comment, gc);
                if (!ComponentPanelBuilder.this.myResizeX) {
                    ++gc.gridx;
                    gc.weightx = 1.0;
                    gc.fill = 0;
                    panel2.add((Component)new JPanel(), gc);
                }
            }
            ComponentPanelBuilder.this.myComponent.putClientProperty("JComponent.decoratedPanel", this);
            ++gc.gridy;
        }

        private MouseEvent convertMouseEvent(MouseEvent e) {
            Point p = e.getPoint();
            SwingUtilities.convertPoint(e.getComponent(), p, ComponentPanelBuilder.this.myComponent);
            return new MouseEvent(ComponentPanelBuilder.this.myComponent, e.getID(), e.getWhen(), e.getModifiers(), p.x, p.y, e.getXOnScreen(), e.getYOnScreen(), e.getClickCount(), e.isPopupTrigger(), e.getButton());
        }
    }
}

