/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.TextAccessor;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.util.ui.UIUtil;
import java.awt.event.ActionListener;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextFieldWithBrowseButton
extends ComponentWithBrowseButton<JTextField>
implements TextAccessor {
    public TextFieldWithBrowseButton() {
        this((ActionListener)null);
    }

    public TextFieldWithBrowseButton(JTextField field) {
        this(field, (ActionListener)null);
    }

    public TextFieldWithBrowseButton(JTextField field, @Nullable ActionListener browseActionListener) {
        this(field, browseActionListener, null);
    }

    public TextFieldWithBrowseButton(JTextField field, @Nullable ActionListener browseActionListener, @Nullable Disposable parent) {
        super(field, browseActionListener);
        if (!(field instanceof JBTextField)) {
            UIUtil.addUndoRedoActions((JTextComponent)field);
        }
        this.installPathCompletion(FileChooserDescriptorFactory.createSingleLocalFileDescriptor(), parent);
    }

    public TextFieldWithBrowseButton(ActionListener browseActionListener) {
        this(browseActionListener, (Disposable)null);
    }

    public TextFieldWithBrowseButton(ActionListener browseActionListener, Disposable parent) {
        this(new ExtendableTextField(10), browseActionListener, parent);
    }

    public void addBrowseFolderListener(@Nullable @NlsContexts.DialogTitle String title, @Nullable @NlsContexts.Label String description, @Nullable Project project, FileChooserDescriptor fileChooserDescriptor) {
        this.addBrowseFolderListener(title, description, project, fileChooserDescriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        this.installPathCompletion(fileChooserDescriptor);
    }

    public void addBrowseFolderListener(@NotNull TextBrowseFolderListener listener2) {
        listener2.setOwnerComponent(this);
        this.addActionListener(listener2);
        this.installPathCompletion(listener2.getFileChooserDescriptor());
    }

    protected void installPathCompletion(FileChooserDescriptor fileChooserDescriptor) {
        this.installPathCompletion(fileChooserDescriptor, null);
    }

    protected void installPathCompletion(FileChooserDescriptor fileChooserDescriptor, @Nullable Disposable parent) {
        Application application = ApplicationManager.getApplication();
        if (application == null || application.isUnitTestMode() || application.isHeadlessEnvironment()) {
            return;
        }
        FileChooserFactory.getInstance().installFileCompletion((JTextField)this.getChildComponent(), fileChooserDescriptor, true, parent);
    }

    @NotNull
    public JTextField getTextField() {
        return (JTextField)this.getChildComponent();
    }

    @NotNull
    public String getText() {
        return StringUtil.notNullize((String)this.getTextField().getText());
    }

    public void setText(@Nls @Nullable String text) {
        this.getTextField().setText(text);
    }

    public boolean isEditable() {
        return this.getTextField().isEditable();
    }

    public void setEditable(boolean b) {
        this.getTextField().setEditable(b);
        this.getButton().setFocusable(!b);
    }

    public static class NoPathCompletion
    extends TextFieldWithBrowseButton {
        public NoPathCompletion() {
        }

        public NoPathCompletion(JTextField field) {
            super(field);
        }

        public NoPathCompletion(JTextField field, ActionListener browseActionListener) {
            super(field, browseActionListener);
        }

        public NoPathCompletion(ActionListener browseActionListener) {
            super(browseActionListener);
        }

        @Override
        protected void installPathCompletion(FileChooserDescriptor fileChooserDescriptor, @Nullable Disposable parent) {
        }
    }
}

