/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapManagerListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ShadowAction {
    private final AnAction myAction;
    private AnAction myCopyFromAction;
    private final Reference<JComponent> myComponent;
    private String myActionId;
    private Presentation myPresentation;
    private final Disposable parentDisposable;
    private Disposable listenerDisposable;
    private Disposable shortcutSetDisposable;

    public ShadowAction(AnAction action, AnAction copyFromAction, JComponent component, Presentation presentation, @NotNull Disposable parentDisposable) {
        this(action, copyFromAction, component, parentDisposable);
        this.myPresentation = presentation;
    }

    public ShadowAction(AnAction action, AnAction copyFromAction, JComponent component, @NotNull Disposable parentDisposable) {
        this.myAction = action;
        this.parentDisposable = parentDisposable;
        this.myCopyFromAction = copyFromAction;
        this.myComponent = new WeakReference<JComponent>(component);
        this.myActionId = ActionManager.getInstance().getId(this.myCopyFromAction);
        this.myAction.getTemplatePresentation().copyFrom(copyFromAction.getTemplatePresentation());
        Disposer.register((Disposable)parentDisposable, (Disposable)new UiNotifyConnector(component, new Activatable(){

            @Override
            public void showNotify() {
                ShadowAction.this._connect();
            }

            @Override
            public void hideNotify() {
                ShadowAction.this.disposeListeners();
            }
        }));
    }

    private void _connect() {
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            return;
        }
        if (this.listenerDisposable == null) {
            this.listenerDisposable = Disposer.newDisposable();
            Disposer.register((Disposable)this.parentDisposable, (Disposable)this.listenerDisposable);
            application.getMessageBus().connect(this.listenerDisposable).subscribe(KeymapManagerListener.TOPIC, (Object)new KeymapManagerListener(){

                @Override
                public void activeKeymapChanged(@Nullable Keymap keymap) {
                    ShadowAction.this.rebound();
                }

                @Override
                public void shortcutChanged(@NotNull Keymap keymap, @NotNull String actionId) {
                    if (ShadowAction.this.myActionId == null || actionId.equals(ShadowAction.this.myActionId)) {
                        ShadowAction.this.rebound();
                    }
                }
            });
        }
        this.rebound();
    }

    private void disposeListeners() {
        Disposable disposable = this.listenerDisposable;
        if (disposable != null) {
            this.listenerDisposable = null;
            Disposer.dispose((Disposable)disposable);
        }
        this.disposeShortcutSetListener();
    }

    private void rebound() {
        this.disposeShortcutSetListener();
        KeymapManager keymapManager = ShadowAction.getKeymapManager();
        if (keymapManager == null) {
            return;
        }
        this.myActionId = ActionManager.getInstance().getId(this.myCopyFromAction);
        if (this.myPresentation == null) {
            this.myAction.copyFrom(this.myCopyFromAction);
        } else {
            this.myAction.getTemplatePresentation().copyFrom(this.myPresentation);
            this.myAction.copyShortcutFrom(this.myCopyFromAction);
        }
        if (this.myActionId == null) {
            return;
        }
        Keymap keymap = keymapManager.getActiveKeymap();
        if (keymap == null) {
            return;
        }
        CustomShortcutSet shortcutSet = new CustomShortcutSet(keymap.getShortcuts(this.myActionId));
        this.shortcutSetDisposable = Disposer.newDisposable();
        Disposer.register((Disposable)this.parentDisposable, (Disposable)this.shortcutSetDisposable);
        this.myAction.registerCustomShortcutSet(shortcutSet, this.myComponent.get(), this.shortcutSetDisposable);
    }

    private void disposeShortcutSetListener() {
        Disposable disposable = this.shortcutSetDisposable;
        if (disposable != null) {
            this.shortcutSetDisposable = null;
            Disposer.dispose((Disposable)disposable);
        }
    }

    @Nullable
    private static KeymapManager getKeymapManager() {
        return ApplicationManager.getApplication().isDisposed() ? null : KeymapManager.getInstance();
    }

    public void reconnect(AnAction copyFromAction) {
        this.myCopyFromAction = copyFromAction;
        this._connect();
    }
}

