/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.diagnostic.LoadingState;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.BrowseFolderRunnable;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.lang.ref.WeakReference;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentWithBrowseButton<Comp extends JComponent>
extends JPanel
implements Disposable {
    private final Comp myComponent;
    private final FixedSizeButton myBrowseButton;
    private boolean myButtonEnabled = true;
    private KeyEvent myCurrentEvent = null;

    @ApiStatus.Internal
    public static boolean isUseInlineBrowserButton() {
        return !LoadingState.COMPONENTS_REGISTERED.isOccurred() || Experiments.getInstance().isFeatureEnabled("inline.browse.button");
    }

    public ComponentWithBrowseButton(@NotNull Comp component, @Nullable ActionListener browseActionListener) {
        super(new BorderLayout(SystemInfo.isMac || StartupUiUtil.isUnderDarcula() ? 0 : 2, 0));
        boolean inlineBrowseButton;
        this.myComponent = component;
        this.setFocusable(false);
        boolean bl = inlineBrowseButton = this.myComponent instanceof ExtendableTextComponent && ComponentWithBrowseButton.isUseInlineBrowserButton();
        if (inlineBrowseButton) {
            ((ExtendableTextComponent)this.myComponent).addExtension(ExtendableTextComponent.Extension.create(this.getDefaultIcon(), this.getHoveredIcon(), this.getIconTooltip(), this::notifyActionListeners));
            new DumbAwareAction(){

                @Override
                public void actionPerformed(@NotNull AnActionEvent e) {
                    ComponentWithBrowseButton.this.notifyActionListeners();
                }
            }.registerCustomShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(10, 64)), (JComponent)this.myComponent);
        }
        this.add((Component)this.myComponent, "Center");
        this.myBrowseButton = new FixedSizeButton((JComponent)this.myComponent);
        if (this.isBackgroundSet()) {
            this.myBrowseButton.setBackground(this.getBackground());
        }
        if (browseActionListener != null) {
            this.myBrowseButton.addActionListener(browseActionListener);
        }
        if (!inlineBrowseButton) {
            this.add((Component)this.myBrowseButton, "East");
        }
        this.myBrowseButton.setToolTipText(this.getIconTooltip());
        if (ApplicationManager.getApplication() != null) {
            new MyDoClickAction(this.myBrowseButton).registerShortcut((JComponent)this.myComponent);
        }
        if (ScreenReader.isActive()) {
            this.myBrowseButton.setFocusable(true);
            this.myBrowseButton.getAccessibleContext().setAccessibleName("Browse");
        }
        new LazyDisposable(this);
    }

    @NotNull
    protected Icon getDefaultIcon() {
        return AllIcons.General.OpenDisk;
    }

    @NotNull
    protected Icon getHoveredIcon() {
        return AllIcons.General.OpenDiskHover;
    }

    @NotNull
    protected String getIconTooltip() {
        return ComponentWithBrowseButton.getTooltip();
    }

    @NotNull
    public static String getTooltip() {
        return UIBundle.message("component.with.browse.button.browse.button.tooltip.text", new Object[0]) + " (" + KeymapUtil.getKeystrokeText(KeyStroke.getKeyStroke(10, 64)) + ")";
    }

    private void notifyActionListeners() {
        ActionEvent event = new ActionEvent(this.myComponent, 1001, "action");
        for (ActionListener listener2 : this.myBrowseButton.getActionListeners()) {
            listener2.actionPerformed(event);
        }
    }

    @NotNull
    public final Comp getChildComponent() {
        return this.myComponent;
    }

    public void setTextFieldPreferredWidth(int charCount) {
        Comp comp = this.getChildComponent();
        Dimension size = GuiUtils.getSizeByChars(charCount, comp);
        ((JComponent)comp).setPreferredSize(size);
        Dimension preferredSize = this.myBrowseButton.getPreferredSize();
        boolean keepHeight = UIUtil.isUnderWin10LookAndFeel();
        preferredSize.setSize(size.width + preferredSize.width + 2, keepHeight ? preferredSize.height : preferredSize.height + 2);
        this.setPreferredSize(preferredSize);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.myBrowseButton.setEnabled(enabled && this.myButtonEnabled);
        ((JComponent)this.myComponent).setEnabled(enabled);
    }

    public void setButtonEnabled(boolean buttonEnabled) {
        this.myButtonEnabled = buttonEnabled;
        this.setEnabled(this.isEnabled());
    }

    public void setButtonIcon(@NotNull Icon icon) {
        this.myBrowseButton.setIcon(icon);
        this.myBrowseButton.setDisabledIcon(IconLoader.getDisabledIcon((Icon)icon));
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.myBrowseButton != null) {
            this.myBrowseButton.setBackground(color);
        }
    }

    public void addActionListener(ActionListener listener2) {
        this.myBrowseButton.addActionListener(listener2);
    }

    public void removeActionListener(ActionListener listener2) {
        this.myBrowseButton.removeActionListener(listener2);
    }

    public void addBrowseFolderListener(@Nullable @NlsContexts.DialogTitle String title, @Nullable @NlsContexts.Label String description, @Nullable Project project, FileChooserDescriptor fileChooserDescriptor, TextComponentAccessor<? super Comp> accessor) {
        this.addActionListener(new BrowseFolderActionListener<Comp>(title, description, this, project, fileChooserDescriptor, accessor));
    }

    @Deprecated
    public void addBrowseFolderListener(@Nullable @NlsContexts.DialogTitle String title, @Nullable @NlsContexts.Label String description, @Nullable Project project, FileChooserDescriptor fileChooserDescriptor, TextComponentAccessor<? super Comp> accessor, boolean autoRemoveOnHide) {
        this.addBrowseFolderListener(title, description, project, fileChooserDescriptor, accessor);
    }

    @Deprecated
    public void addBrowseFolderListener(@Nullable Project project, BrowseFolderActionListener<Comp> actionListener) {
        this.addActionListener(actionListener);
    }

    public void dispose() {
        ActionListener[] listeners;
        for (ActionListener listener2 : listeners = this.myBrowseButton.getActionListeners()) {
            this.myBrowseButton.removeActionListener(listener2);
        }
    }

    public FixedSizeButton getButton() {
        return this.myBrowseButton;
    }

    @Override
    public final void requestFocus() {
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myComponent, true));
    }

    @Override
    public final void setNextFocusableComponent(Component aComponent) {
        super.setNextFocusableComponent(aComponent);
        ((JComponent)this.myComponent).setNextFocusableComponent(aComponent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (condition == 0 && this.myCurrentEvent != e) {
            try {
                this.myCurrentEvent = e;
                ((Component)this.myComponent).dispatchEvent(e);
            }
            finally {
                this.myCurrentEvent = null;
            }
        }
        if (e.isConsumed()) {
            return true;
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    @Deprecated
    public void addBrowseFolderListener(@Nullable Project project, BrowseFolderActionListener<Comp> actionListener, boolean autoRemoveOnHide) {
        this.addActionListener(actionListener);
    }

    private static final class LazyDisposable
    implements Activatable {
        private final WeakReference<ComponentWithBrowseButton<?>> reference;

        private LazyDisposable(ComponentWithBrowseButton<?> component) {
            this.reference = new WeakReference(component);
            new UiNotifyConnector.Once(component, this);
        }

        @Override
        public void showNotify() {
            Disposable disposable;
            ComponentWithBrowseButton component = (ComponentWithBrowseButton)this.reference.get();
            if (component == null) {
                return;
            }
            Disposable disposable2 = disposable = ApplicationManager.getApplication() == null ? null : PlatformDataKeys.UI_DISPOSABLE.getData(DataManager.getInstance().getDataContext(component));
            if (disposable == null) {
                return;
            }
            Disposer.register((Disposable)disposable, (Disposable)component);
        }
    }

    public static class BrowseFolderActionListener<T extends JComponent>
    extends BrowseFolderRunnable<T>
    implements ActionListener {
        public BrowseFolderActionListener(@Nullable @NlsContexts.DialogTitle String title, @Nullable @NlsContexts.Label String description, @Nullable ComponentWithBrowseButton<T> textField, @Nullable Project project, FileChooserDescriptor fileChooserDescriptor, TextComponentAccessor<? super T> accessor) {
            super(title, description, project, fileChooserDescriptor, textField != null ? (Object)textField.getChildComponent() : null, accessor);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.run();
        }
    }

    public static final class MyDoClickAction
    extends DumbAwareAction {
        private final FixedSizeButton myBrowseButton;

        public MyDoClickAction(FixedSizeButton browseButton) {
            this.myBrowseButton = browseButton;
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setEnabled(this.myBrowseButton.isVisible() && this.myBrowseButton.isEnabled());
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            this.myBrowseButton.doClick();
        }

        public void registerShortcut(JComponent textField) {
            CustomShortcutSet shiftEnter = new CustomShortcutSet(KeyStroke.getKeyStroke(10, 64));
            this.registerCustomShortcutSet(shiftEnter, textField);
            this.myBrowseButton.setToolTipText(KeymapUtil.getShortcutsText(shiftEnter.getShortcuts()));
        }

        public static void addTo(FixedSizeButton browseButton, JComponent aComponent) {
            new MyDoClickAction(browseButton).registerShortcut(aComponent);
        }
    }
}

