/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.util;

import com.intellij.openapi.roots.ui.ModifiableCellAppearanceEx;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleTextCellAppearance
implements ModifiableCellAppearanceEx {
    private Icon myIcon;
    private final SimpleTextAttributes myTextAttributes;
    private final String myText;

    public static SimpleTextCellAppearance regular(@NotNull String text, @Nullable Icon icon) {
        return new SimpleTextCellAppearance(text, icon, SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    public static SimpleTextCellAppearance invalid(@NotNull String text, @Nullable Icon icon) {
        return new SimpleTextCellAppearance(text, icon, SimpleTextAttributes.ERROR_ATTRIBUTES);
    }

    public static SimpleTextCellAppearance synthetic(@NotNull String text, @Nullable Icon icon) {
        return new SimpleTextCellAppearance(text, icon, SimpleTextAttributes.SYNTHETIC_ATTRIBUTES);
    }

    public SimpleTextCellAppearance(@NotNull String text, @Nullable Icon icon, @NotNull SimpleTextAttributes textAttributes) {
        this.myIcon = icon;
        this.myTextAttributes = textAttributes;
        this.myText = text;
    }

    @Override
    public void customize(@NotNull SimpleColoredComponent component) {
        component.setIcon(this.myIcon);
        component.append(this.myText, this.myTextAttributes);
    }

    @Override
    @NotNull
    public String getText() {
        return this.myText;
    }

    @NotNull
    public SimpleTextAttributes getTextAttributes() {
        return this.myTextAttributes;
    }

    @Override
    public void setIcon(@Nullable Icon icon) {
        this.myIcon = icon;
    }
}

