/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.roots.PersistentOrderRootType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OrderRootType {
    private final String myName;
    private static boolean ourExtensionsLoaded = false;
    public static final ExtensionPointName<OrderRootType> EP_NAME = ExtensionPointName.create((String)"com.intellij.orderRootType");
    static PersistentOrderRootType @NotNull [] ourPersistentOrderRootTypes = new PersistentOrderRootType[0];
    public static final OrderRootType CLASSES = new PersistentOrderRootType("CLASSES", "classPath", null, "classPathEntry");
    public static final OrderRootType SOURCES = new PersistentOrderRootType("SOURCES", "sourcePath", null, "sourcePathEntry");
    public static final OrderRootType DOCUMENTATION = new DocumentationRootType();

    protected OrderRootType(@NotNull String name) {
        this.myName = name;
    }

    @NotNull
    public String name() {
        return this.myName;
    }

    public boolean skipWriteIfEmpty() {
        return false;
    }

    public static synchronized OrderRootType @NotNull [] getAllTypes() {
        return OrderRootType.getAllPersistentTypes();
    }

    public static PersistentOrderRootType @NotNull [] getAllPersistentTypes() {
        if (!ourExtensionsLoaded) {
            ourExtensionsLoaded = true;
            EP_NAME.getExtensionList();
        }
        return ourPersistentOrderRootTypes;
    }

    @NotNull
    public static List<PersistentOrderRootType> getSortedRootTypes() {
        ArrayList<PersistentOrderRootType> allTypes = new ArrayList<PersistentOrderRootType>();
        Collections.addAll(allTypes, OrderRootType.getAllPersistentTypes());
        allTypes.sort((o1, o2) -> o1.name().compareToIgnoreCase(o2.name()));
        return allTypes;
    }

    @NotNull
    protected static <T> T getOrderRootType(@NotNull Class<? extends T> orderRootTypeClass) {
        List rootTypes = EP_NAME.getExtensionList();
        for (OrderRootType rootType : rootTypes) {
            if (!orderRootTypeClass.isInstance(rootType)) continue;
            OrderRootType t = rootType;
            return (T)t;
        }
        assert (false) : "Root type " + orderRootTypeClass + " not found. All roots: " + rootTypes;
        return null;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public String toString() {
        return "Root " + this.name();
    }

    public static class DocumentationRootType
    extends OrderRootType {
        public DocumentationRootType() {
            super("DOCUMENTATION");
        }

        @Override
        public boolean skipWriteIfEmpty() {
            return true;
        }
    }
}

