/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JdkFinder;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.SdkVersionUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.lang.JavaVersion;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.stream.Stream;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JdkVersionDetector;

public class SimpleJavaSdkType
extends SdkType
implements JavaSdkType {
    private static final Condition<SdkTypeId> TRUE = sdkTypeId -> true;
    private static final Condition<SdkTypeId> NOT_SIMPLE_JAVA_TYPE = sdkTypeId -> !(sdkTypeId instanceof SimpleJavaSdkType);
    private static final Condition<SdkTypeId> NOT_DEPENDENT_TYPE = sdkTypeId -> sdkTypeId instanceof SdkType && ((SdkType)sdkTypeId).getDependencyType() == null;

    public static SimpleJavaSdkType getInstance() {
        return SdkType.findInstance(SimpleJavaSdkType.class);
    }

    public SimpleJavaSdkType() {
        super("SimpleJavaSdkType");
    }

    public Sdk createJdk(@NotNull String jdkName, @NotNull String home) {
        Sdk jdk = ProjectJdkTable.getInstance().createSdk(jdkName, this);
        SdkModificator sdkModificator = jdk.getSdkModificator();
        sdkModificator.setHomePath(FileUtil.toSystemIndependentName((String)home));
        sdkModificator.commitChanges();
        return jdk;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return ProjectBundle.message("sdk.java.name", new Object[0]);
    }

    @Override
    public AdditionalDataConfigurable createAdditionalDataConfigurable(@NotNull SdkModel sdkModel, @NotNull SdkModificator sdkModificator) {
        return null;
    }

    @Override
    public void saveAdditionalData(@NotNull SdkAdditionalData additionalData2, @NotNull Element additional) {
    }

    @Override
    public String getBinPath(@NotNull Sdk sdk) {
        return new File(sdk.getHomePath(), "bin").getPath();
    }

    @Override
    public String getToolsPath(@NotNull Sdk sdk) {
        return new File(sdk.getHomePath(), "lib/tools.jar").getPath();
    }

    @Override
    public String getVMExecutablePath(@NotNull Sdk sdk) {
        return new File(sdk.getHomePath(), "bin/java").getPath();
    }

    @Override
    @Nullable
    public String suggestHomePath() {
        return JdkFinder.getInstance().defaultJavaLocation();
    }

    @Override
    @NotNull
    public Collection<String> suggestHomePaths() {
        if (!SimpleJavaSdkType.notSimpleJavaSdkTypeIfAlternativeExists().value((Object)this)) {
            return Collections.emptyList();
        }
        return JdkFinder.getInstance().suggestHomePaths();
    }

    @Override
    public boolean isValidSdkHome(String path2) {
        return JdkUtil.checkForJdk(path2);
    }

    @Override
    @NotNull
    public String suggestSdkName(@Nullable String currentSdkName, String sdkHome) {
        String suggestedName = JdkUtil.suggestJdkName(this.getVersionString(sdkHome));
        return suggestedName != null ? suggestedName : (currentSdkName != null ? currentSdkName : "");
    }

    @Override
    public final String getVersionString(String sdkHome) {
        JdkVersionDetector.JdkVersionInfo jdkInfo = SdkVersionUtil.getJdkVersionInfo(sdkHome);
        return jdkInfo != null ? JdkVersionDetector.formatVersionString(jdkInfo.version) : null;
    }

    @Override
    @NotNull
    public Comparator<String> versionStringComparator() {
        return (sdk1, sdk2) -> Comparing.compare((Comparable)JavaVersion.tryParse((String)sdk1), (Comparable)JavaVersion.tryParse((String)sdk2));
    }

    @NotNull
    public static Condition<SdkTypeId> notSimpleJavaSdkType() {
        return NOT_SIMPLE_JAVA_TYPE;
    }

    @NotNull
    public static Condition<SdkTypeId> notSimpleJavaSdkType(@Nullable Condition<? super SdkTypeId> condition) {
        if (condition == null) {
            return NOT_SIMPLE_JAVA_TYPE;
        }
        return sdkTypeId -> NOT_SIMPLE_JAVA_TYPE.value(sdkTypeId) && condition.value(sdkTypeId);
    }

    @NotNull
    public static Condition<SdkTypeId> notSimpleJavaSdkTypeIfAlternativeExists() {
        boolean hasNotSimple = Stream.of(SdkType.getAllTypes()).filter(arg_0 -> SimpleJavaSdkType.notSimpleJavaSdkType().value(arg_0)).anyMatch(it -> it instanceof JavaSdkType && it.getDependencyType() == null && !((JavaSdkType)((Object)it)).isDependent());
        if (hasNotSimple) {
            return NOT_SIMPLE_JAVA_TYPE;
        }
        return TRUE;
    }

    @NotNull
    public static Condition<SdkTypeId> notSimpleJavaSdkTypeIfAlternativeExistsAndNotDependentSdkType() {
        Condition<SdkTypeId> preferablyNotSimple = SimpleJavaSdkType.notSimpleJavaSdkTypeIfAlternativeExists();
        return sdkType -> sdkType instanceof JavaSdkType && NOT_DEPENDENT_TYPE.value(sdkType) && preferablyNotSimple.value(sdkType);
    }
}

