/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.IconUtil;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SdkType
implements SdkTypeId {
    public static final ExtensionPointName<SdkType> EP_NAME = ExtensionPointName.create((String)"com.intellij.sdkType");
    private static final Comparator<Sdk> ALPHABETICAL_COMPARATOR = (sdk1, sdk2) -> StringUtil.compare((String)sdk1.getName(), (String)sdk2.getName(), (boolean)true);
    private final String myName;

    public SdkType(@NotNull String name) {
        this.myName = name;
    }

    @Nullable
    public abstract String suggestHomePath();

    @NotNull
    public Collection<String> suggestHomePaths() {
        String home = this.suggestHomePath();
        return home != null ? Collections.singletonList(home) : Collections.emptyList();
    }

    public boolean isRelevantForFile(@NotNull Project project, @NotNull VirtualFile file) {
        return true;
    }

    @NotNull
    public String adjustSelectedSdkHome(@NotNull String homePath) {
        return homePath;
    }

    public abstract boolean isValidSdkHome(String var1);

    public String getInvalidHomeMessage(String path2) {
        return new File(path2).isDirectory() ? ProjectBundle.message("sdk.configure.home.invalid.error", this.getPresentableName()) : ProjectBundle.message("sdk.configure.home.file.invalid.error", this.getPresentableName());
    }

    @Override
    @Nullable
    public String getVersionString(@NotNull Sdk sdk) {
        return this.getVersionString(sdk.getHomePath());
    }

    @Nullable
    public String getVersionString(String sdkHome) {
        return null;
    }

    @NotNull
    public abstract String suggestSdkName(@Nullable String var1, String var2);

    @NotNull
    public Comparator<Sdk> getComparator() {
        return ALPHABETICAL_COMPARATOR;
    }

    public boolean setupSdkPaths(@NotNull Sdk sdk, @NotNull SdkModel sdkModel) {
        this.setupSdkPaths(sdk);
        return true;
    }

    public void setupSdkPaths(@NotNull Sdk sdk) {
    }

    @Nullable
    public abstract AdditionalDataConfigurable createAdditionalDataConfigurable(@NotNull SdkModel var1, @NotNull SdkModificator var2);

    @Nullable
    public SdkAdditionalData loadAdditionalData(@NotNull Element additional) {
        return null;
    }

    @Override
    @Nullable
    public SdkAdditionalData loadAdditionalData(@NotNull Sdk currentSdk, @NotNull Element additional) {
        return this.loadAdditionalData(additional);
    }

    @Override
    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Title)
    public abstract String getPresentableName();

    public Icon getIcon() {
        return null;
    }

    @NotNull
    public String getHelpTopic() {
        return "preferences.jdks";
    }

    @NotNull
    public Icon getIconForAddAction() {
        return IconUtil.getAddIcon();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SdkType)) {
            return false;
        }
        SdkType sdkType = (SdkType)o;
        return this.myName.equals(sdkType.myName);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    public String toString() {
        return this.getName();
    }

    @NotNull
    public FileChooserDescriptor getHomeChooserDescriptor() {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, false, false, false){

            @Override
            public void validateSelectedFiles(VirtualFile @NotNull [] files) throws Exception {
                String selectedPath;
                boolean valid;
                if (files.length != 0 && !(valid = SdkType.this.isValidSdkHome(selectedPath = files[0].getPath())) && !(valid = SdkType.this.isValidSdkHome(SdkType.this.adjustSelectedSdkHome(selectedPath)))) {
                    String message = SdkType.this.getInvalidHomeMessage(selectedPath);
                    throw new Exception(message);
                }
            }
        };
        descriptor.setTitle(ProjectBundle.message("sdk.configure.home.title", this.getPresentableName()));
        return descriptor;
    }

    @NotNull
    public String getHomeFieldLabel() {
        return ProjectBundle.message("sdk.configure.type.home.path", this.getPresentableName());
    }

    @Nullable
    public String getDefaultDocumentationUrl(@NotNull Sdk sdk) {
        return null;
    }

    @Nullable
    public String getDownloadSdkUrl() {
        return null;
    }

    public static SdkType @NotNull [] getAllTypes() {
        return (SdkType[])EP_NAME.getExtensions();
    }

    @Nullable
    public static SdkType findByName(@Nullable String sdkName) {
        if (sdkName == null) {
            return null;
        }
        for (SdkType sdkType : SdkType.getAllTypes()) {
            if (!Comparing.strEqual((String)sdkType.getName(), (String)sdkName)) continue;
            return sdkType;
        }
        return null;
    }

    @NotNull
    public static <T extends SdkType> T findInstance(@NotNull Class<T> sdkTypeClass) {
        for (SdkType sdkType : EP_NAME.getExtensionList()) {
            if (!sdkTypeClass.equals(sdkType.getClass())) continue;
            return (T)((SdkType)sdkTypeClass.cast(sdkType));
        }
        throw new IllegalArgumentException("Unknown SDk type: " + sdkTypeClass);
    }

    public SdkType getDependencyType() {
        return null;
    }

    public boolean isRootTypeApplicable(@NotNull OrderRootType type) {
        return true;
    }

    public boolean supportsCustomCreateUI() {
        return false;
    }

    public void showCustomCreateUI(@NotNull SdkModel sdkModel, @NotNull JComponent parentComponent, @Nullable Sdk selectedSdk, @NotNull Consumer<Sdk> sdkCreatedCallback) {
        this.showCustomCreateUI(sdkModel, parentComponent, sdkCreatedCallback);
    }

    @Deprecated
    public void showCustomCreateUI(@NotNull SdkModel sdkModel, @NotNull JComponent parentComponent, @NotNull Consumer<Sdk> sdkCreatedCallback) {
    }

    public boolean sdkHasValidPath(@NotNull Sdk sdk) {
        VirtualFile homeDir = sdk.getHomeDirectory();
        return homeDir != null && homeDir.isValid();
    }

    @NotNull
    public String sdkPath(@NotNull VirtualFile homePath) {
        return homePath.getPath();
    }

    public boolean allowCreationByUser() {
        return true;
    }
}

