/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ProjectExtensionPointName;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbModePermission;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DumbService {
    public static final Topic<DumbModeListener> DUMB_MODE = new Topic("dumb mode", DumbModeListener.class);
    private static final NotNullLazyKey<DumbService, Project> INSTANCE_KEY = ServiceManager.createLazyKey(DumbService.class);

    public abstract ModificationTracker getModificationTracker();

    public abstract boolean isDumb();

    public static boolean isDumb(@NotNull Project project) {
        return DumbService.getInstance(project).isDumb();
    }

    @NotNull
    public static <T> List<T> getDumbAwareExtensions(@NotNull Project project, @NotNull ExtensionPointName<T> extensionPoint) {
        List list = extensionPoint.getExtensionList();
        if (list.isEmpty()) {
            return list;
        }
        DumbService dumbService = DumbService.getInstance(project);
        return dumbService.filterByDumbAwareness(list);
    }

    @NotNull
    public static <T> List<T> getDumbAwareExtensions(@NotNull Project project, @NotNull ProjectExtensionPointName<T> extensionPoint) {
        DumbService dumbService = DumbService.getInstance(project);
        return dumbService.filterByDumbAwareness(extensionPoint.getExtensions((AreaInstance)project));
    }

    public abstract void runWhenSmart(@NotNull Runnable var1);

    public abstract void waitForSmartMode();

    public <T> T runReadActionInSmartMode(@NotNull Computable<T> r) {
        Ref result = new Ref();
        this.runReadActionInSmartMode(() -> result.set(r.compute()));
        return (T)result.get();
    }

    @Nullable
    public <T> T tryRunReadActionInSmartMode(@NotNull Computable<T> task, @Nullable String notification) {
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            try {
                return (T)task.compute();
            }
            catch (IndexNotReadyException e) {
                if (notification != null) {
                    this.showDumbModeNotification(notification);
                }
                return null;
            }
        }
        return this.runReadActionInSmartMode(task);
    }

    public void runReadActionInSmartMode(@NotNull Runnable r) {
        boolean success;
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            r.run();
            return;
        }
        do {
            this.waitForSmartMode();
        } while (!(success = ((Boolean)ReadAction.compute(() -> {
            if (this.getProject().isDisposed()) {
                throw new ProcessCanceledException();
            }
            if (this.isDumb()) {
                return false;
            }
            r.run();
            return true;
        })).booleanValue()));
    }

    @Deprecated
    public void repeatUntilPassesInSmartMode(@NotNull Runnable r) {
        while (true) {
            this.waitForSmartMode();
            try {
                r.run();
                return;
            }
            catch (IndexNotReadyException indexNotReadyException) {
                continue;
            }
            break;
        }
    }

    public abstract void smartInvokeLater(@NotNull Runnable var1);

    public abstract void smartInvokeLater(@NotNull Runnable var1, @NotNull ModalityState var2);

    public static DumbService getInstance(@NotNull Project project) {
        return (DumbService)INSTANCE_KEY.getValue((UserDataHolder)project);
    }

    @NotNull
    public <T> List<T> filterByDumbAwareness(T @NotNull [] array) {
        return this.filterByDumbAwareness(Arrays.asList(array));
    }

    @Contract(pure=true)
    @NotNull
    public <T> List<T> filterByDumbAwareness(@NotNull Collection<? extends T> collection) {
        if (this.isDumb()) {
            ArrayList<T> result = new ArrayList<T>(collection.size());
            for (T element : collection) {
                if (!DumbService.isDumbAware(element)) continue;
                result.add(element);
            }
            return result;
        }
        return collection instanceof List ? (List<Object>)collection : new ArrayList<T>(collection);
    }

    public abstract void queueTask(@NotNull DumbModeTask var1);

    public abstract void cancelTask(@NotNull DumbModeTask var1);

    @ApiStatus.Internal
    public abstract void cancelAllTasksAndWait();

    public abstract void completeJustSubmittedTasks();

    public abstract JComponent wrapGently(@NotNull JComponent var1, @NotNull Disposable var2);

    public abstract JComponent wrapWithSpoiler(@NotNull JComponent var1, @NotNull Runnable var2, @NotNull Disposable var3);

    public void makeDumbAware(final @NotNull JComponent componentToDisable, @NotNull Disposable parentDisposable) {
        componentToDisable.setEnabled(!this.isDumb());
        this.getProject().getMessageBus().connect(parentDisposable).subscribe(DUMB_MODE, (Object)new DumbModeListener(){

            @Override
            public void enteredDumbMode() {
                componentToDisable.setEnabled(false);
            }

            @Override
            public void exitDumbMode() {
                componentToDisable.setEnabled(true);
            }
        });
    }

    public abstract void showDumbModeNotification(@NotNull @NlsContexts.PopupContent String var1);

    public abstract void showDumbModeActionBalloon(@NotNull @NlsContexts.PopupContent String var1, @NotNull Runnable var2);

    public abstract Project getProject();

    @Contract(value="null -> false", pure=true)
    public static boolean isDumbAware(Object o) {
        if (o instanceof PossiblyDumbAware) {
            return ((PossiblyDumbAware)o).isDumbAware();
        }
        return o instanceof DumbAware;
    }

    @Deprecated
    public abstract void setAlternativeResolveEnabled(boolean var1);

    public void withAlternativeResolveEnabled(@NotNull Runnable runnable) {
        this.setAlternativeResolveEnabled(true);
        try {
            runnable.run();
        }
        finally {
            this.setAlternativeResolveEnabled(false);
        }
    }

    public <T, E extends Throwable> T computeWithAlternativeResolveEnabled(@NotNull ThrowableComputable<T, E> runnable) throws E {
        this.setAlternativeResolveEnabled(true);
        try {
            Object object = runnable.compute();
            return (T)object;
        }
        finally {
            this.setAlternativeResolveEnabled(false);
        }
    }

    public <E extends Throwable> void runWithAlternativeResolveEnabled(@NotNull ThrowableRunnable<E> runnable) throws E {
        this.setAlternativeResolveEnabled(true);
        try {
            runnable.run();
        }
        finally {
            this.setAlternativeResolveEnabled(false);
        }
    }

    public abstract boolean isAlternativeResolveEnabled();

    @Deprecated
    public static void allowStartingDumbModeInside(@NotNull DumbModePermission permission, @NotNull Runnable runnable) {
        runnable.run();
    }

    public abstract void suspendIndexingAndRun(@NotNull @Nls(capitalization=Nls.Capitalization.Sentence) String var1, @NotNull Runnable var2);

    public abstract boolean isSuspendedDumbMode();

    @ApiStatus.Internal
    public abstract void unsafeRunWhenSmart(@NotNull Runnable var1);

    public static interface DumbModeListener {
        default public void enteredDumbMode() {
        }

        default public void exitDumbMode() {
        }
    }
}

