/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SearchableConfigurable
extends Configurable {
    @NotNull
    @NonNls
    public String getId();

    @Nullable
    default public Runnable enableSearch(String option) {
        return null;
    }

    @NotNull
    default public Class<?> getOriginalClass() {
        return this.getClass();
    }

    public static class Delegate
    implements SearchableConfigurable {
        private final Configurable myConfigurable;

        public Delegate(@NotNull Configurable configurable) {
            this.myConfigurable = configurable;
        }

        @Override
        @NotNull
        public String getId() {
            return this.myConfigurable instanceof SearchableConfigurable ? ((SearchableConfigurable)this.myConfigurable).getId() : this.myConfigurable.getClass().getName();
        }

        @Override
        @Nullable
        public Runnable enableSearch(String option) {
            return this.myConfigurable instanceof SearchableConfigurable ? ((SearchableConfigurable)this.myConfigurable).enableSearch(option) : null;
        }

        @Override
        @Nls
        public String getDisplayName() {
            return this.myConfigurable.getDisplayName();
        }

        @Override
        @Nullable
        public String getHelpTopic() {
            return this.myConfigurable.getHelpTopic();
        }

        @Override
        @Nullable
        public JComponent createComponent() {
            return this.myConfigurable.createComponent();
        }

        @Override
        public boolean isModified() {
            return this.myConfigurable.isModified();
        }

        @Override
        public void apply() throws ConfigurationException {
            this.myConfigurable.apply();
        }

        @Override
        public void reset() {
            this.myConfigurable.reset();
        }

        @Override
        public void disposeUIResources() {
            this.myConfigurable.disposeUIResources();
        }
    }

    @FunctionalInterface
    public static interface Merged {
        public List<Configurable> getMergedConfigurables();
    }

    public static interface Parent
    extends SearchableConfigurable,
    Configurable.Composite {
        default public boolean hasOwnContent() {
            return false;
        }

        @Deprecated
        default public boolean isVisible() {
            return true;
        }

        public static abstract class Abstract
        implements Parent {
            private Configurable[] myKids;

            @Override
            public JComponent createComponent() {
                return null;
            }

            @Override
            public boolean isModified() {
                return false;
            }

            @Override
            public void apply() throws ConfigurationException {
            }

            @Override
            public void disposeUIResources() {
                this.myKids = null;
            }

            @Override
            public final Configurable @NotNull [] getConfigurables() {
                if (this.myKids != null) {
                    return this.myKids;
                }
                this.myKids = this.buildConfigurables();
                return this.myKids;
            }

            protected abstract Configurable[] buildConfigurables();
        }
    }
}

