/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class UserFileType<T extends UserFileType<T>>
implements FileType,
Cloneable {
    @NotNull
    private String myName = "";
    private String myDescription = "";
    private Icon myIcon;
    private String myIconPath;

    public abstract SettingsEditor<T> getEditor();

    public UserFileType<T> clone() {
        try {
            return (UserFileType)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    @NotNull
    public String getName() {
        return this.myName;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.myDescription;
    }

    public void setName(@NotNull String name) {
        this.myName = name;
    }

    public void setDescription(String description) {
        this.myDescription = description;
    }

    @Override
    @NotNull
    public String getDefaultExtension() {
        return "";
    }

    @Override
    public Icon getIcon() {
        Icon icon = this.myIcon;
        if (icon == null) {
            if (this.myIconPath != null) {
                this.myIcon = icon = IconLoader.getIcon((String)this.myIconPath);
            }
            if (icon == null) {
                icon = PlatformIcons.CUSTOM_FILE_ICON;
            }
        }
        return icon;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String getCharset(@NotNull VirtualFile file, byte @NotNull [] content) {
        return null;
    }

    public void copyFrom(@NotNull UserFileType<T> newType) {
        this.myName = newType.getName();
        this.myDescription = newType.getDescription();
    }

    public void setIcon(@NotNull Icon icon) {
        this.myIcon = icon;
    }

    public void setIconPath(@NotNull String value) {
        this.myIconPath = value;
    }

    public String toString() {
        return this.myName;
    }
}

