/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.TextEditor;
import org.jetbrains.annotations.NotNull;

public class TextEditorLocation
implements FileEditorLocation {
    private static final Logger LOG = Logger.getInstance(TextEditorLocation.class);
    private final TextEditor myEditor;
    private final LogicalPosition myPosition;

    public TextEditorLocation(int offset, @NotNull TextEditor editor) {
        this(editor.getEditor().offsetToLogicalPosition(offset), editor);
    }

    public TextEditorLocation(@NotNull LogicalPosition position, @NotNull TextEditor editor) {
        this.myEditor = editor;
        this.myPosition = position;
    }

    @Override
    @NotNull
    public FileEditor getEditor() {
        return this.myEditor;
    }

    @NotNull
    public LogicalPosition getPosition() {
        return this.myPosition;
    }

    @Override
    public int compareTo(@NotNull FileEditorLocation fileEditorLocation) {
        TextEditorLocation otherLocation = (TextEditorLocation)fileEditorLocation;
        if (this.myEditor != otherLocation.myEditor) {
            LOG.error("Different editors: " + this.myEditor + "; and " + otherLocation.myEditor);
        }
        return this.myPosition.compareTo(otherLocation.myPosition);
    }

    public String toString() {
        return this.myPosition.toString();
    }
}

