/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.util;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class IntegrationKey {
    @NotNull
    private final String myIdeProjectName;
    @NotNull
    private final String myIdeProjectLocationHash;
    @NotNull
    private final ProjectSystemId myExternalSystemId;
    @NotNull
    private final String myExternalProjectConfigPath;

    public IntegrationKey(@NotNull Project ideProject, @NotNull ProjectSystemId externalSystemId, @NotNull String externalProjectConfigPath) {
        this(ideProject.getName(), ideProject.getLocationHash(), externalSystemId, externalProjectConfigPath);
    }

    public IntegrationKey(@NotNull String ideProjectName, @NotNull String ideProjectLocationHash, @NotNull ProjectSystemId externalSystemId, @NotNull String externalProjectConfigPath) {
        this.myIdeProjectName = ideProjectName;
        this.myIdeProjectLocationHash = ideProjectLocationHash;
        this.myExternalSystemId = externalSystemId;
        this.myExternalProjectConfigPath = externalProjectConfigPath;
    }

    @NotNull
    public String getIdeProjectName() {
        return this.myIdeProjectName;
    }

    @NotNull
    public String getIdeProjectLocationHash() {
        return this.myIdeProjectLocationHash;
    }

    @NotNull
    public ProjectSystemId getExternalSystemId() {
        return this.myExternalSystemId;
    }

    @NotNull
    public String getExternalProjectConfigPath() {
        return this.myExternalProjectConfigPath;
    }

    public int hashCode() {
        int result = this.myIdeProjectName.hashCode();
        result = 31 * result + this.myIdeProjectLocationHash.hashCode();
        result = 31 * result + this.myExternalSystemId.hashCode();
        result = 31 * result + this.myExternalProjectConfigPath.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntegrationKey key = (IntegrationKey)o;
        if (!this.myExternalSystemId.equals(key.myExternalSystemId)) {
            return false;
        }
        if (!this.myIdeProjectLocationHash.equals(key.myIdeProjectLocationHash)) {
            return false;
        }
        if (!this.myIdeProjectName.equals(key.myIdeProjectName)) {
            return false;
        }
        return this.myExternalProjectConfigPath.equals(key.myExternalProjectConfigPath);
    }

    public String toString() {
        return String.format("%s project '%s'", StringUtil.toLowerCase((String)this.myExternalSystemId.toString()), this.myIdeProjectName);
    }
}

