/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.task;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractExternalEntityData;
import com.intellij.openapi.externalSystem.model.project.ExternalConfigPathAware;
import com.intellij.serialization.PropertyMapping;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TaskData
extends AbstractExternalEntityData
implements ExternalConfigPathAware,
Comparable<TaskData> {
    @NotNull
    private final String name;
    @Nullable
    private final String description;
    @NotNull
    private final String linkedExternalProjectPath;
    @Nullable
    private String group;
    @Nullable
    private String type;
    private boolean inherited;
    private boolean isTest;

    @PropertyMapping(value={"owner", "name", "linkedExternalProjectPath", "description"})
    public TaskData(@NotNull ProjectSystemId owner, @NotNull String name, @NotNull String linkedExternalProjectPath, @Nullable String description) {
        super(owner);
        this.name = name;
        this.linkedExternalProjectPath = linkedExternalProjectPath;
        this.description = description;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getLinkedExternalProjectPath() {
        return this.linkedExternalProjectPath;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public String getGroup() {
        return this.group;
    }

    public void setGroup(@Nullable String group) {
        this.group = group;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    public void setType(@Nullable String type) {
        this.type = type;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public void setInherited(boolean inherited) {
        this.inherited = inherited;
    }

    public boolean isTest() {
        return this.isTest;
    }

    public void setTest(boolean test) {
        this.isTest = test;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + (this.group != null ? this.group.hashCode() : 0);
        result = 31 * result + this.linkedExternalProjectPath.hashCode();
        result = 31 * result + (this.inherited ? 1 : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TaskData data = (TaskData)o;
        if (this.inherited != data.inherited) {
            return false;
        }
        if (!this.name.equals(data.name)) {
            return false;
        }
        if (this.group != null ? !this.group.equals(data.group) : data.group != null) {
            return false;
        }
        if (!this.linkedExternalProjectPath.equals(data.linkedExternalProjectPath)) {
            return false;
        }
        return !(this.description != null ? !this.description.equals(data.description) : data.description != null);
    }

    @Override
    public int compareTo(@NotNull TaskData that) {
        return this.name.compareTo(that.getName());
    }

    public String toString() {
        return this.name;
    }
}

