/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.project;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractNamedData;
import com.intellij.openapi.externalSystem.model.project.ExternalConfigPathAware;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.Identifiable;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.Named;
import com.intellij.openapi.externalSystem.model.project.ProjectCoordinate;
import com.intellij.openapi.externalSystem.model.project.ProjectId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.serialization.Property;
import com.intellij.serialization.PropertyMapping;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleData
extends AbstractNamedData
implements Named,
ExternalConfigPathAware,
Identifiable {
    @NotNull
    private final Map<ExternalSystemSourceType, String> compileOutputPaths = new HashMap<ExternalSystemSourceType, String>();
    @NotNull
    private final Map<ExternalSystemSourceType, String> externalCompilerOutputPaths = new HashMap<ExternalSystemSourceType, String>();
    @Nullable
    private Map<String, String> properties;
    @NotNull
    private final String id;
    @NotNull
    private final String moduleTypeId;
    @NotNull
    private final String externalConfigPath;
    @NotNull
    private final String moduleFileDirectoryPath;
    @Nullable
    private String group;
    @Nullable
    private String version;
    @Nullable
    private String description;
    @NotNull
    private List<File> artifacts;
    private String @Nullable [] ideModuleGroup;
    @Nullable
    private String sourceCompatibility;
    @Nullable
    private String targetCompatibility;
    @Nullable
    private String sdkName;
    private boolean isSetSourceCompatibility = false;
    private boolean isSetTargetCompatibility = false;
    private boolean isSetSdkName = false;
    @Nullable
    private String productionModuleId;
    @NotNull
    private String moduleName;
    @Property(allowedTypes={LibraryData.class, ProjectId.class})
    @Nullable
    private ProjectCoordinate publication;
    private boolean inheritProjectCompileOutputPath = true;
    private boolean useExternalCompilerOutput;

    @PropertyMapping(value={"id", "owner", "moduleTypeId", "externalName", "moduleFileDirectoryPath", "externalConfigPath"})
    public ModuleData(@NotNull String id, @NotNull ProjectSystemId owner, @NotNull String moduleTypeId, @NotNull String externalName, @NotNull String moduleFileDirectoryPath, @NotNull String externalConfigPath) {
        super(owner, externalName, externalName.replaceAll("(/|\\\\)", "_"));
        this.id = id;
        this.moduleTypeId = moduleTypeId;
        this.externalConfigPath = externalConfigPath;
        this.artifacts = Collections.emptyList();
        this.moduleFileDirectoryPath = moduleFileDirectoryPath;
        this.moduleName = externalName;
    }

    protected ModuleData(@NotNull String id, @NotNull ProjectSystemId owner, @NotNull String typeId, @NotNull String externalName, @NotNull String internalName, @NotNull String moduleFileDirectoryPath, @NotNull String externalConfigPath) {
        super(owner, externalName, internalName);
        this.id = id;
        this.moduleTypeId = typeId;
        this.externalConfigPath = externalConfigPath;
        this.artifacts = Collections.emptyList();
        this.moduleFileDirectoryPath = moduleFileDirectoryPath;
        this.moduleName = externalName;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getModuleTypeId() {
        return this.moduleTypeId;
    }

    @Override
    @NotNull
    public String getLinkedExternalProjectPath() {
        return this.externalConfigPath;
    }

    @NotNull
    public String getModuleFileDirectoryPath() {
        return this.moduleFileDirectoryPath;
    }

    @Nullable
    public String getProductionModuleId() {
        return this.productionModuleId;
    }

    public void setProductionModuleId(@Nullable String productionModuleId) {
        this.productionModuleId = productionModuleId;
    }

    public boolean isInheritProjectCompileOutputPath() {
        return this.inheritProjectCompileOutputPath;
    }

    public void setInheritProjectCompileOutputPath(boolean inheritProjectCompileOutputPath) {
        this.inheritProjectCompileOutputPath = inheritProjectCompileOutputPath;
    }

    @Nullable
    public String getCompileOutputPath(@NotNull ExternalSystemSourceType type) {
        return this.useExternalCompilerOutput && this.externalCompilerOutputPaths != null ? this.externalCompilerOutputPaths.get(type) : this.compileOutputPaths.get(type);
    }

    public void setCompileOutputPath(@NotNull ExternalSystemSourceType type, @Nullable String path2) {
        ModuleData.updatePath(this.compileOutputPaths, type, path2);
    }

    public void setExternalCompilerOutputPath(@NotNull ExternalSystemSourceType type, @Nullable String path2) {
        ModuleData.updatePath(this.externalCompilerOutputPaths, type, path2);
    }

    public void useExternalCompilerOutput(boolean useExternalCompilerOutput) {
        this.useExternalCompilerOutput = useExternalCompilerOutput;
    }

    @Nullable
    public String getGroup() {
        return this.group;
    }

    public void setGroup(@Nullable String group) {
        this.group = group;
    }

    @Nullable
    public ProjectCoordinate getPublication() {
        return this.publication;
    }

    public void setPublication(@Nullable ProjectCoordinate publication) {
        this.publication = publication;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    public void setVersion(@Nullable String version) {
        this.version = version;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    @NotNull
    public List<File> getArtifacts() {
        return this.artifacts;
    }

    public void setArtifacts(@NotNull List<File> artifacts) {
        this.artifacts = artifacts;
    }

    public String @Nullable [] getIdeModuleGroup() {
        return this.ideModuleGroup;
    }

    public void setIdeModuleGroup(String @Nullable [] ideModuleGroup) {
        this.ideModuleGroup = ideModuleGroup;
    }

    @Deprecated
    @Nullable
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public String getSourceCompatibility() {
        return this.sourceCompatibility;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public void setSourceCompatibility(@Nullable String sourceCompatibility) {
        this.isSetSourceCompatibility = true;
        this.sourceCompatibility = sourceCompatibility;
    }

    @Deprecated
    @Nullable
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public String getTargetCompatibility() {
        return this.targetCompatibility;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public void setTargetCompatibility(@Nullable String targetCompatibility) {
        this.isSetTargetCompatibility = true;
        this.targetCompatibility = targetCompatibility;
    }

    @Deprecated
    @Nullable
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public String getSdkName() {
        return this.sdkName;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public void setSdkName(@Nullable String sdkName) {
        this.isSetSdkName = true;
        this.sdkName = sdkName;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public void internalSetSourceCompatibility(@Nullable String sourceCompatibility) {
        this.sourceCompatibility = sourceCompatibility;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public void internalSetTargetCompatibility(@Nullable String targetCompatibility) {
        this.targetCompatibility = targetCompatibility;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public void internalSetSdkName(@Nullable String sdkName) {
        this.sdkName = sdkName;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public boolean isSetSourceCompatibility() {
        return this.isSetSourceCompatibility;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public boolean isSetTargetCompatibility() {
        return this.isSetTargetCompatibility;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public boolean isSetSdkName() {
        return this.isSetSdkName;
    }

    @Nullable
    public String getProperty(String key) {
        return this.properties != null ? this.properties.get(key) : null;
    }

    public void setProperty(String key, String value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, value);
    }

    @NotNull
    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(@NotNull String moduleName) {
        this.moduleName = moduleName;
    }

    @Nullable
    public String getIdeGrouping() {
        if (this.ideModuleGroup != null) {
            return StringUtil.join((String[])this.ideModuleGroup, (String)".");
        }
        return this.getInternalName();
    }

    @Nullable
    public String getIdeParentGrouping() {
        if (this.ideModuleGroup != null) {
            return StringUtil.nullize((String)StringUtil.join((String[])((String[])ArrayUtil.remove((Object[])this.ideModuleGroup, (int)(this.ideModuleGroup.length - 1))), (String)"."));
        }
        String name = this.getInternalName();
        int i = name.lastIndexOf("." + this.moduleName);
        if (i > -1) {
            return name.substring(0, i);
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ModuleData)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ModuleData that = (ModuleData)o;
        if (!this.id.equals(that.id)) {
            return false;
        }
        if (!this.externalConfigPath.equals(that.externalConfigPath)) {
            return false;
        }
        if (this.group != null ? !this.group.equals(that.group) : that.group != null) {
            return false;
        }
        if (!this.moduleTypeId.equals(that.moduleTypeId)) {
            return false;
        }
        if (this.version != null ? !this.version.equals(that.version) : that.version != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        return !(this.sdkName != null ? !this.sdkName.equals(that.sdkName) : that.sdkName != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.id.hashCode();
        result = 31 * result + this.externalConfigPath.hashCode();
        result = 31 * result + this.moduleTypeId.hashCode();
        result = 31 * result + (this.group != null ? this.group.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.sdkName != null ? this.sdkName.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.getId();
    }

    private static void updatePath(Map<ExternalSystemSourceType, String> paths, @NotNull ExternalSystemSourceType type, @Nullable String path2) {
        if (paths == null) {
            return;
        }
        if (path2 == null) {
            paths.remove(type);
            return;
        }
        paths.put(type, ExternalSystemApiUtil.toCanonicalPath(path2));
    }
}

