/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.project;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractExternalEntityData;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.serialization.PropertyMapping;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ContentRootData
extends AbstractExternalEntityData {
    @NotNull
    private final Map<ExternalSystemSourceType, Collection<SourceRoot>> data = new HashMap<ExternalSystemSourceType, Collection<SourceRoot>>();
    @NotNull
    private final String rootPath;

    @PropertyMapping(value={"owner", "rootPath"})
    public ContentRootData(@NotNull ProjectSystemId owner, @NotNull String rootPath) {
        super(owner);
        this.rootPath = ExternalSystemApiUtil.toCanonicalPath(rootPath);
    }

    @NotNull
    public Collection<SourceRoot> getPaths(@NotNull ExternalSystemSourceType type) {
        Collection<SourceRoot> result = this.data.get(type);
        return result == null ? Collections.emptyList() : result;
    }

    public void storePath(@NotNull ExternalSystemSourceType type, @NotNull String path2) throws IllegalArgumentException {
        this.storePath(type, path2, null);
    }

    public void storePath(@NotNull ExternalSystemSourceType type, @NotNull String path2, @Nullable String packagePrefix) throws IllegalArgumentException {
        if (FileUtil.isAncestor((File)new File(this.getRootPath()), (File)new File(path2), (boolean)false)) {
            Collection<SourceRoot> paths = this.data.get(type);
            if (paths == null) {
                paths = new TreeSet<SourceRoot>(SourceRootComparator.INSTANCE);
                this.data.put(type, paths);
            }
            paths.add(new SourceRoot(ExternalSystemApiUtil.toCanonicalPath(path2), StringUtil.nullize((String)packagePrefix, (boolean)true)));
            return;
        }
        if (!ExternalSystemSourceType.EXCLUDED.equals((Object)type)) {
            throw new IllegalArgumentException(String.format("Can't register given path of type '%s' because it's out of content root.%nContent root: '%s'%nGiven path: '%s'", type, this.getRootPath(), new File(path2).getAbsolutePath()));
        }
    }

    @NotNull
    public String getRootPath() {
        return this.rootPath;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("content root:");
        for (Map.Entry<ExternalSystemSourceType, Collection<SourceRoot>> entry : this.data.entrySet()) {
            buffer.append(StringUtil.toLowerCase((String)entry.getKey().toString())).append("=").append(entry.getValue()).append("|");
        }
        if (!this.data.isEmpty()) {
            buffer.setLength(buffer.length() - 1);
        }
        return buffer.toString();
    }

    private static final class SourceRootComparator
    implements Comparator<SourceRoot>,
    Serializable {
        private static final SourceRootComparator INSTANCE = new SourceRootComparator();

        private SourceRootComparator() {
        }

        @Override
        public int compare(@NotNull SourceRoot o1, @NotNull SourceRoot o2) {
            return StringUtil.naturalCompare((String)o1.path, (String)o2.path);
        }
    }

    public static class SourceRoot
    implements Serializable {
        @NotNull
        private final String path;
        @Nullable
        private final String packagePrefix;

        public SourceRoot(@NotNull String path2, @Nullable String prefix) {
            this.path = path2;
            this.packagePrefix = prefix;
        }

        private SourceRoot() {
            this.path = "";
            this.packagePrefix = "";
        }

        @NotNull
        public String getPath() {
            return this.path;
        }

        @Nullable
        public String getPackagePrefix() {
            return this.packagePrefix;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SourceRoot)) {
                return false;
            }
            SourceRoot root = (SourceRoot)o;
            if (this.packagePrefix != null ? !this.packagePrefix.equals(root.packagePrefix) : root.packagePrefix != null) {
                return false;
            }
            return this.path.equals(root.path);
        }

        public int hashCode() {
            int result = this.path.hashCode();
            result = 31 * result + (this.packagePrefix != null ? this.packagePrefix.hashCode() : 0);
            return result;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder("source_root(");
            buffer.append(this.path);
            if (this.packagePrefix != null) {
                buffer.append(", ").append(this.packagePrefix);
            }
            buffer.append(")");
            return buffer.toString();
        }
    }
}

