/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.execution;

import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="ExternalSystemSettings")
public class ExternalSystemTaskExecutionSettings
implements Cloneable {
    @NotNull
    @NonNls
    public static final String TAG_NAME = "ExternalSystemSettings";
    @NotNull
    @NonNls
    public static final Key<ParametersList> JVM_AGENT_SETUP_KEY = Key.create((String)"jvmAgentSetup");
    @NotNull
    private List<String> myTaskNames = new ArrayList<String>();
    @NotNull
    private List<String> myTaskDescriptions = new ArrayList<String>();
    @Nullable
    private String myExecutionName;
    private String myExternalSystemIdString;
    private String myExternalProjectPath;
    private String myVmOptions;
    private String myScriptParameters;
    @NotNull
    private Map<String, String> myEnv = new HashMap<String, String>();
    private boolean myPassParentEnvs = true;

    public ExternalSystemTaskExecutionSettings() {
    }

    private ExternalSystemTaskExecutionSettings(@NotNull ExternalSystemTaskExecutionSettings source) {
        this.setFrom(source);
    }

    public void setFrom(@NotNull ExternalSystemTaskExecutionSettings source) {
        this.myExecutionName = source.myExecutionName;
        this.myExternalSystemIdString = source.myExternalSystemIdString;
        this.myExternalProjectPath = source.myExternalProjectPath;
        this.myVmOptions = source.myVmOptions;
        this.myScriptParameters = source.myScriptParameters;
        this.myTaskNames = ContainerUtil.copyList(source.myTaskNames);
        this.myTaskDescriptions = ContainerUtil.copyList(source.myTaskDescriptions);
        this.myEnv = source.myEnv.isEmpty() ? Collections.emptyMap() : new HashMap<String, String>(source.myEnv);
        this.myPassParentEnvs = source.myPassParentEnvs;
    }

    @Nullable
    public String getExecutionName() {
        return this.myExecutionName;
    }

    public void setExecutionName(@Nullable String executionName) {
        this.myExecutionName = executionName;
    }

    public String getExternalSystemIdString() {
        return this.myExternalSystemIdString;
    }

    public ProjectSystemId getExternalSystemId() {
        return new ProjectSystemId(this.myExternalSystemIdString);
    }

    public void setExternalSystemIdString(String externalSystemIdString) {
        this.myExternalSystemIdString = externalSystemIdString;
    }

    public String getExternalProjectPath() {
        return this.myExternalProjectPath;
    }

    public void setExternalProjectPath(String externalProjectPath) {
        this.myExternalProjectPath = externalProjectPath;
    }

    public String getVmOptions() {
        return this.myVmOptions;
    }

    public void setVmOptions(String vmOptions) {
        this.myVmOptions = vmOptions;
    }

    public String getScriptParameters() {
        return this.myScriptParameters;
    }

    public void setScriptParameters(String scriptParameters) {
        this.myScriptParameters = scriptParameters;
    }

    @NotNull
    public List<String> getTaskNames() {
        return this.myTaskNames;
    }

    public void setTaskNames(@NotNull List<String> taskNames) {
        this.myTaskNames = taskNames;
    }

    @NotNull
    public List<String> getTaskDescriptions() {
        return this.myTaskDescriptions;
    }

    public void setTaskDescriptions(@NotNull List<String> taskDescriptions) {
        this.myTaskDescriptions = taskDescriptions;
    }

    @NotNull
    public Map<String, String> getEnv() {
        return this.myEnv;
    }

    public void setEnv(@NotNull Map<String, String> value) {
        this.myEnv = value;
    }

    public boolean isPassParentEnvs() {
        return this.myPassParentEnvs;
    }

    public void setPassParentEnvs(boolean passParentEnvs) {
        this.myPassParentEnvs = passParentEnvs;
    }

    public ExternalSystemTaskExecutionSettings clone() {
        return new ExternalSystemTaskExecutionSettings(this);
    }

    public int hashCode() {
        int result = this.myTaskNames.hashCode();
        result = 31 * result + (this.myExecutionName != null ? this.myExecutionName.hashCode() : 0);
        result = 31 * result + (this.myExternalSystemIdString != null ? this.myExternalSystemIdString.hashCode() : 0);
        result = 31 * result + (this.myExternalProjectPath != null ? this.myExternalProjectPath.hashCode() : 0);
        result = 31 * result + (this.myVmOptions != null ? this.myVmOptions.hashCode() : 0);
        result = 31 * result + (this.myScriptParameters != null ? this.myScriptParameters.hashCode() : 0);
        result = 31 * result + this.myEnv.hashCode();
        result = 31 * result + (this.myPassParentEnvs ? 1 : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalSystemTaskExecutionSettings settings = (ExternalSystemTaskExecutionSettings)o;
        if (!Objects.equals(this.myExecutionName, settings.myExecutionName)) {
            return false;
        }
        if (!Objects.equals(this.myExternalProjectPath, settings.myExternalProjectPath)) {
            return false;
        }
        if (!Objects.equals(this.myExternalSystemIdString, settings.myExternalSystemIdString)) {
            return false;
        }
        if (!Objects.equals(this.myTaskNames, settings.myTaskNames)) {
            return false;
        }
        if (StringUtil.isEmpty((String)this.myVmOptions) ^ StringUtil.isEmpty((String)settings.myVmOptions)) {
            return false;
        }
        if (StringUtil.isEmpty((String)this.myScriptParameters) ^ StringUtil.isEmpty((String)settings.myScriptParameters)) {
            return false;
        }
        if (!Objects.equals(this.myEnv, settings.myEnv)) {
            return false;
        }
        return this.myPassParentEnvs == settings.myPassParentEnvs;
    }

    public String toString() {
        return StringUtil.join(this.myTaskNames, (String)" ") + (StringUtil.isEmpty((String)this.myScriptParameters) ? "" : " " + this.myScriptParameters) + (StringUtil.isEmpty((String)this.myVmOptions) ? "" : " " + this.myVmOptions);
    }
}

