/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.serialization.PropertyMapping;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProjectSystemId
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final Map<String, ProjectSystemId> ourExistingIds = new ConcurrentHashMap<String, ProjectSystemId>();
    @NotNull
    public static final ProjectSystemId IDE = new ProjectSystemId("IDE");
    @NotNull
    private final String id;
    @NotNull
    private final String readableName;

    public ProjectSystemId(@NotNull String id) {
        this(id, StringUtil.capitalize((String)StringUtil.toLowerCase((String)id)));
    }

    @PropertyMapping(value={"id", "readableName"})
    public ProjectSystemId(@NotNull String id, @NotNull @Nls String readableName) {
        this.id = id;
        this.readableName = readableName;
        ourExistingIds.putIfAbsent(id, this);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectSystemId owner = (ProjectSystemId)o;
        return this.id.equals(owner.id);
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getReadableName() {
        return this.readableName;
    }

    public String toString() {
        return this.id;
    }

    @NotNull
    public ProjectSystemId intern() {
        ProjectSystemId current = ourExistingIds.putIfAbsent(this.id, this);
        return current == null ? this : current;
    }

    @Nullable
    public static ProjectSystemId findById(@NotNull String id) {
        return ourExistingIds.get(id);
    }

    private Object readResolve() {
        ProjectSystemId cached = ourExistingIds.get(this.id);
        if (cached != null) {
            return cached;
        }
        return this;
    }
}

