/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import com.intellij.util.containers.ContainerUtil;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataNode<T>
implements UserDataHolderEx,
Serializable {
    private static final Logger LOG = Logger.getInstance(DataNode.class);
    @NotNull
    private Key<T> key;
    @Nullable
    private volatile transient UserDataHolderBase internalUserDataOrNull = null;
    private static final AtomicFieldUpdater<DataNode, UserDataHolderBase> userDataUpdater = AtomicFieldUpdater.forFieldOfType(DataNode.class, UserDataHolderBase.class);
    @Nullable
    private T data;
    private boolean ignored;
    private volatile transient boolean ready;
    @Nullable
    private DataNode<?> parent;
    @Nullable
    private List<DataNode<?>> children;
    @Nullable
    private transient List<DataNode<?>> childrenView;

    public DataNode(@NotNull Key<T> key, @NotNull T data, @Nullable DataNode<?> parent) {
        this.key = key;
        this.data = data;
        this.parent = parent;
    }

    public boolean isReady() {
        return this.ready;
    }

    private DataNode() {
    }

    @Nullable
    public DataNode<?> getParent() {
        return this.parent;
    }

    @NotNull
    public <T> DataNode<T> createChild(@NotNull Key<T> key, @NotNull T data) {
        DataNode<T> result = new DataNode<T>(key, data, this);
        this.doAddChild(result);
        return result;
    }

    @NotNull
    public Key<T> getKey() {
        return this.key;
    }

    @NotNull
    public T getData() {
        return this.data;
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    public void setIgnored(boolean ignored) {
        this.ignored = ignored;
    }

    public void visitData(@Nullable Function visitor) {
        if (visitor == null) {
            return;
        }
        Object newData = visitor.apply(this.getData());
        if (newData != null) {
            this.data = newData;
        }
    }

    @Nullable
    public <T> T getData(@NotNull Key<T> key) {
        if (this.key.equals(key)) {
            return this.data;
        }
        DataNode<?> p = this.parent;
        while (p != null) {
            if (p.key.equals(key)) {
                return p.data;
            }
            p = p.parent;
        }
        return null;
    }

    @Nullable
    public <T> DataNode<T> getDataNode(@NotNull Key<T> key) {
        if (this.key.equals(key)) {
            return this;
        }
        DataNode<?> p = this.parent;
        while (p != null) {
            if (p.key.equals(key)) {
                return p;
            }
            p = p.parent;
        }
        return null;
    }

    @Nullable
    public <P> DataNode<P> getParent(@NotNull Class<P> dataClass) {
        if (dataClass.isInstance(this.data)) {
            return this;
        }
        DataNode<?> p = this.parent;
        while (p != null) {
            if (dataClass.isInstance(p.data)) {
                return p;
            }
            p = p.parent;
        }
        return null;
    }

    public void addChild(@NotNull DataNode<?> child) {
        child.parent = this;
        this.doAddChild(child);
    }

    private void doAddChild(@NotNull DataNode<?> child) {
        if (this.children == null) {
            ArrayList newChildren = new ArrayList();
            newChildren.add(child);
            this.initChildren(newChildren);
        } else {
            this.children.add(child);
        }
    }

    private void initChildren(@Nullable List<DataNode<?>> children) {
        this.children = children;
        this.childrenView = null;
    }

    @NotNull
    public Collection<DataNode<?>> getChildren() {
        if (this.children == null || this.children.isEmpty()) {
            return Collections.emptyList();
        }
        List<DataNode<?>> result = this.childrenView;
        if (result == null) {
            this.childrenView = result = Collections.unmodifiableList(this.children);
        }
        return result;
    }

    public int hashCode() {
        return 31 * this.key.hashCode() + this.getData().hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataNode node = (DataNode)o;
        if (!Objects.equals(this.key, node.key)) {
            return false;
        }
        if (!Objects.equals(this.getData(), node.getData())) {
            return false;
        }
        return Objects.equals(ObjectUtils.notNull(this.children, Collections.emptyList()), ObjectUtils.notNull(node.children, Collections.emptyList()));
    }

    public String toString() {
        String dataDescription;
        try {
            dataDescription = this.getData().toString();
        }
        catch (Exception e) {
            dataDescription = "failed to load";
            LOG.debug((Throwable)e);
        }
        return String.format("%s: %s", this.key, dataDescription);
    }

    public void clear(boolean removeFromGraph) {
        if (removeFromGraph && this.parent != null && this.parent.children != null) {
            Iterator<DataNode<?>> iterator = this.parent.children.iterator();
            while (iterator.hasNext()) {
                DataNode<?> dataNode = iterator.next();
                if (System.identityHashCode(dataNode) != System.identityHashCode(this)) continue;
                iterator.remove();
                if (!this.parent.children.isEmpty()) break;
                super.initChildren(null);
                break;
            }
        }
        this.parent = null;
        this.initChildren(null);
    }

    @NotNull
    public DataNode<T> graphCopy() {
        return DataNode.copy(this, null);
    }

    @NotNull
    public DataNode<T> nodeCopy() {
        return DataNode.nodeCopy(this);
    }

    @Nullable
    public <U> U getUserData(@NotNull com.intellij.openapi.util.Key<U> key) {
        UserDataHolderBase holder = this.getUserDataHolder();
        return (U)(holder == null ? null : holder.getUserData(key));
    }

    public <U> void putUserData(@NotNull com.intellij.openapi.util.Key<U> key, U value) {
        this.getOrCreateUserDataHolder().putUserData(key, value);
    }

    public <U> void removeUserData(@NotNull com.intellij.openapi.util.Key<U> key) {
        this.getOrCreateUserDataHolder().putUserData(key, null);
    }

    @NotNull
    public <D> D putUserDataIfAbsent(@NotNull com.intellij.openapi.util.Key<D> key, @NotNull D value) {
        return (D)this.getOrCreateUserDataHolder().putUserDataIfAbsent(key, value);
    }

    public <D> boolean replace(@NotNull com.intellij.openapi.util.Key<D> key, @Nullable D oldValue, @Nullable D newValue) {
        return this.getOrCreateUserDataHolder().replace(key, oldValue, newValue);
    }

    public <T> void putCopyableUserData(@NotNull com.intellij.openapi.util.Key<T> key, T value) {
        this.getOrCreateUserDataHolder().putCopyableUserData(key, value);
    }

    public <T> T getCopyableUserData(@NotNull com.intellij.openapi.util.Key<T> key) {
        UserDataHolderBase holder = this.getUserDataHolder();
        return (T)(holder == null ? null : holder.getCopyableUserData(key));
    }

    public boolean validateData() {
        if (this.data == null) {
            this.ready = false;
            this.clear(true);
        } else {
            this.ready = true;
        }
        return this.ready;
    }

    @NotNull
    public static <T> DataNode<T> nodeCopy(@NotNull DataNode<T> dataNode) {
        DataNode<T> copy = new DataNode<T>();
        copy.key = dataNode.key;
        copy.data = dataNode.data;
        copy.ignored = dataNode.ignored;
        copy.ready = dataNode.ready;
        UserDataHolderBase userData = super.getUserDataHolder();
        if (userData != null) {
            userData.copyCopyableDataTo(super.getOrCreateUserDataHolder());
        }
        return copy;
    }

    @Nullable
    private UserDataHolderBase getUserDataHolder() {
        return this.internalUserDataOrNull;
    }

    @NotNull
    private UserDataHolderBase getOrCreateUserDataHolder() {
        if (this.internalUserDataOrNull == null) {
            userDataUpdater.compareAndSet((Object)this, null, (Object)new UserDataHolderBase());
        }
        return this.internalUserDataOrNull;
    }

    @NotNull
    private static <T> DataNode<T> copy(@NotNull DataNode<T> dataNode, @Nullable DataNode<?> newParent) {
        DataNode copy = DataNode.nodeCopy(dataNode);
        copy.parent = newParent;
        if (dataNode.children != null) {
            super.initChildren(ContainerUtil.map(dataNode.children, child -> DataNode.copy(child, copy)));
        }
        return copy;
    }

    public final void visit(@NotNull Consumer<? super DataNode<?>> consumer) {
        DataNode node;
        ArrayDeque toProcess = new ArrayDeque();
        toProcess.add(this);
        while ((node = (DataNode)toProcess.pollFirst()) != null) {
            consumer.accept(node);
            if (node.children == null) continue;
            toProcess.addAll(node.children);
        }
    }
}

