/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.openapi.editor.Editor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface LineNumberConverter {
    public static final LineNumberConverter DEFAULT = new LineNumberConverter(){

        @Override
        public Integer convert(@NotNull Editor editor, int lineNumber) {
            return lineNumber;
        }

        @Override
        public Integer getMaxLineNumber(@NotNull Editor editor) {
            return editor.getDocument().getLineCount();
        }
    };

    @Nullable
    public Integer convert(@NotNull Editor var1, int var2);

    @Nullable
    public Integer getMaxLineNumber(@NotNull Editor var1);

    public static interface Increasing
    extends LineNumberConverter {
        @Override
        @Nullable
        default public Integer getMaxLineNumber(@NotNull Editor editor) {
            for (int i = editor.getDocument().getLineCount(); i > 0; --i) {
                Integer number = this.convert(editor, i);
                if (number == null) continue;
                return number;
            }
            return null;
        }
    }
}

