/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.util.NlsActions;
import java.util.function.Function;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToggleOptionAction
extends ToggleAction {
    private final Function<AnActionEvent, Option> optionSupplier;

    public ToggleOptionAction(@NotNull Option option) {
        this(option, null);
    }

    public ToggleOptionAction(@NotNull Option option, @Nullable Icon icon) {
        this((AnActionEvent event) -> option, icon);
    }

    public ToggleOptionAction(@NotNull Function<AnActionEvent, Option> optionSupplier) {
        this(optionSupplier, null);
    }

    public ToggleOptionAction(@NotNull Function<AnActionEvent, Option> optionSupplier, @Nullable Icon icon) {
        super(() -> null, () -> null, icon);
        this.optionSupplier = optionSupplier;
    }

    @Override
    public final boolean isSelected(@NotNull AnActionEvent event) {
        Option option = this.optionSupplier.apply(event);
        return option != null && option.isSelected();
    }

    @Override
    public final void setSelected(@NotNull AnActionEvent event, boolean selected) {
        Option option = this.optionSupplier.apply(event);
        if (option != null) {
            option.setSelected(selected);
        }
    }

    @Override
    public final void update(@NotNull AnActionEvent event) {
        Option option = this.optionSupplier.apply(event);
        boolean enabled = option != null && option.isEnabled();
        boolean visible = enabled || option != null && option.isAlwaysVisible();
        Presentation presentation = event.getPresentation();
        presentation.setEnabled(enabled);
        presentation.setVisible(visible);
        if (visible) {
            String description;
            Toggleable.setSelected(presentation, option.isSelected());
            String name = option.getName();
            if (name != null) {
                presentation.setText(name);
            }
            if ((description = option.getDescription()) != null) {
                presentation.setDescription(description);
            }
            if (ActionPlaces.isPopupPlace(event.getPlace())) {
                presentation.setIcon(null);
            }
        }
    }

    public static interface Option {
        @Nullable
        default public @NlsActions.ActionText String getName() {
            return null;
        }

        @Nullable
        default public @NlsActions.ActionDescription String getDescription() {
            return null;
        }

        default public boolean isEnabled() {
            return true;
        }

        default public boolean isAlwaysVisible() {
            return false;
        }

        public boolean isSelected();

        public void setSelected(boolean var1);
    }
}

