/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Separator
extends AnAction
implements DumbAware,
LightEditCompatible {
    private static final Separator ourInstance = new Separator();
    private final Supplier<String> myDynamicText;

    @NotNull
    public static Separator getInstance() {
        return ourInstance;
    }

    @NotNull
    public static Separator create() {
        return Separator.create(null);
    }

    @NotNull
    public static Separator create(@Nullable @NlsContexts.Separator String text) {
        return StringUtil.isEmptyOrSpaces((String)text) ? ourInstance : new Separator(text);
    }

    public Separator() {
        this.myDynamicText = () -> null;
    }

    public Separator(@Nullable @NlsContexts.Separator String text) {
        this.myDynamicText = () -> text;
    }

    public Separator(@NotNull Supplier<@NlsContexts.Separator String> dynamicText) {
        this.myDynamicText = dynamicText;
    }

    public String getText() {
        return this.myDynamicText.get();
    }

    @Override
    public String toString() {
        return "Separator (" + this.myDynamicText.get() + ")";
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        throw new UnsupportedOperationException();
    }
}

