/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.ide.util.treeView.AbstractTreeUpdater;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.TreeRunnable;
import com.intellij.ide.util.treeView.TreeVisitor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Progressive;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.reference.SoftReference;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Deprecated
@ApiStatus.ScheduledForRemoval(inVersion="2020.3")
public class AbstractTreeBuilder
implements Disposable {
    private AbstractTreeUi myUi;
    @NonNls
    private static final String TREE_BUILDER = "TreeBuilder";
    protected static final boolean DEFAULT_UPDATE_INACTIVE = true;

    public AbstractTreeBuilder(@NotNull JTree tree, @NotNull DefaultTreeModel treeModel, AbstractTreeStructure treeStructure, @Nullable Comparator<? super NodeDescriptor<?>> comparator) {
        this(tree, treeModel, treeStructure, comparator, true);
    }

    public AbstractTreeBuilder(@NotNull JTree tree, @NotNull DefaultTreeModel treeModel, AbstractTreeStructure treeStructure, @Nullable Comparator<? super NodeDescriptor<?>> comparator, boolean updateIfInactive) {
        this.init(tree, treeModel, treeStructure, comparator, updateIfInactive);
    }

    protected AbstractTreeBuilder() {
    }

    protected void init(@NotNull JTree tree, @NotNull DefaultTreeModel treeModel, AbstractTreeStructure treeStructure, @Nullable Comparator<? super NodeDescriptor<?>> comparator, boolean updateIfInactive) {
        tree.putClientProperty(TREE_BUILDER, new WeakReference<AbstractTreeBuilder>(this));
        this.myUi = this.createUi();
        this.myUi.init(this, tree, treeModel, treeStructure, comparator, updateIfInactive);
        this.setPassthroughMode(AbstractTreeBuilder.isUnitTestingMode());
    }

    @NotNull
    protected AbstractTreeUi createUi() {
        return new AbstractTreeUi();
    }

    public final void scrollTo(Object element) {
        this.scrollTo(element, null);
    }

    public final void scrollTo(Object element, Runnable onDone) {
        AbstractTreeUi ui = this.getUi();
        if (ui != null) {
            ui.userScrollTo(element, onDone == null ? null : new UserRunnable(onDone));
        }
    }

    public final void select(Object element) {
        AbstractTreeUi ui = this.getUi();
        if (ui != null) {
            ui.userSelect(new Object[]{element}, null, false, true);
        }
    }

    public final void select(Object element, @Nullable Runnable onDone) {
        AbstractTreeUi ui = this.getUi();
        if (ui != null) {
            ui.userSelect(new Object[]{element}, new UserRunnable(onDone), false, true);
        }
    }

    public final void select(Object element, @Nullable Runnable onDone, boolean addToSelection) {
        AbstractTreeUi ui = this.getUi();
        if (ui != null) {
            ui.userSelect(new Object[]{element}, new UserRunnable(onDone), addToSelection, true);
        }
    }

    public final void select(Object[] elements, @Nullable Runnable onDone) {
        AbstractTreeUi ui = this.getUi();
        if (ui != null) {
            ui.userSelect(elements, new UserRunnable(onDone), false, true);
        }
    }

    public final void select(Object[] elements, @Nullable Runnable onDone, boolean addToSelection) {
        AbstractTreeUi ui = this.getUi();
        if (ui != null) {
            ui.userSelect(elements, new UserRunnable(onDone), addToSelection, true);
        }
    }

    public final void expand(Object element, @Nullable Runnable onDone) {
        AbstractTreeUi ui = this.getUi();
        if (ui != null) {
            ui.expand(element, (Runnable)new UserRunnable(onDone));
        }
    }

    public final void expand(Object[] element, @Nullable Runnable onDone) {
        AbstractTreeUi ui = this.getUi();
        if (ui != null) {
            ui.expand(element, (Runnable)new UserRunnable(onDone));
        }
    }

    public final void collapseChildren(Object element, @Nullable Runnable onDone) {
        AbstractTreeUi ui = this.getUi();
        if (ui != null) {
            ui.collapseChildren(element, new UserRunnable(onDone));
        }
    }

    @NotNull
    static AbstractTreeNode<Object> createSearchingTreeNodeWrapper() {
        return new AbstractTreeNodeWrapper();
    }

    @Nullable
    protected AbstractTreeUpdater createUpdater() {
        if (this.isDisposed()) {
            return null;
        }
        AbstractTreeUpdater updater = new AbstractTreeUpdater(this);
        updater.setModalityStateComponent(MergingUpdateQueue.ANY_COMPONENT);
        return updater;
    }

    @Nullable
    protected final AbstractTreeUpdater getUpdater() {
        AbstractTreeUi ui = this.getUi();
        return ui == null ? null : ui.getUpdater();
    }

    public final boolean addSubtreeToUpdateByElement(@NotNull Object element) {
        AbstractTreeUpdater updater = this.getUpdater();
        return updater != null && updater.addSubtreeToUpdateByElement(element);
    }

    public final void addSubtreeToUpdate(DefaultMutableTreeNode node) {
        AbstractTreeUi ui = this.getUi();
        if (ui != null) {
            ui.addSubtreeToUpdate(node);
        }
    }

    public final void addSubtreeToUpdate(DefaultMutableTreeNode node, Runnable afterUpdate) {
        AbstractTreeUi ui = this.getUi();
        if (ui != null) {
            ui.addSubtreeToUpdate(node, afterUpdate);
        }
    }

    @Nullable
    public final DefaultMutableTreeNode getRootNode() {
        AbstractTreeUi ui = this.getUi();
        return ui == null ? null : ui.getRootNode();
    }

    public final void setNodeDescriptorComparator(Comparator<? super NodeDescriptor<?>> nodeDescriptorComparator) {
        AbstractTreeUi ui = this.getUi();
        if (ui != null) {
            ui.setNodeDescriptorComparator(nodeDescriptorComparator);
        }
    }

    protected Object getTreeStructureElement(NodeDescriptor nodeDescriptor) {
        return nodeDescriptor == null ? null : nodeDescriptor.getElement();
    }

    protected void updateNode(DefaultMutableTreeNode node) {
        AbstractTreeUi ui = this.getUi();
        if (ui != null) {
            ui.doUpdateNode(node);
        }
    }

    protected boolean validateNode(@NotNull Object child) {
        AbstractTreeStructure structure = this.getTreeStructure();
        return structure != null && structure.isValid(child);
    }

    protected boolean isDisposeOnCollapsing(NodeDescriptor nodeDescriptor) {
        return true;
    }

    public final JTree getTree() {
        AbstractTreeUi ui = this.getUi();
        return ui == null ? null : ui.getTree();
    }

    public final AbstractTreeStructure getTreeStructure() {
        AbstractTreeUi ui = this.getUi();
        return ui == null ? null : ui.getTreeStructure();
    }

    public final void setTreeStructure(@NotNull AbstractTreeStructure structure) {
        AbstractTreeUi ui = this.getUi();
        if (ui != null) {
            ui.setTreeStructure(structure);
        }
    }

    @Nullable
    public Object getRootElement() {
        AbstractTreeStructure structure = this.getTreeStructure();
        return structure == null ? null : structure.getRootElement();
    }

    @Deprecated
    public void updateFromRoot() {
        this.queueUpdate();
    }

    public void initRootNode() {
        AbstractTreeUi ui = this.getUi();
        if (ui != null) {
            ui.initRootNode();
        }
    }

    @NotNull
    public final ActionCallback queueUpdate() {
        return this.queueUpdate(true);
    }

    @NotNull
    public final ActionCallback queueUpdate(boolean withStructure) {
        return this.queueUpdateFrom(this.getRootElement(), true, withStructure);
    }

    @NotNull
    public final ActionCallback queueUpdateFrom(Object element, boolean forceResort) {
        return this.queueUpdateFrom(element, forceResort, true);
    }

    @NotNull
    public ActionCallback queueUpdateFrom(final Object element, final boolean forceResort, final boolean updateStructure) {
        AbstractTreeUi ui = this.getUi();
        if (ui == null) {
            return ActionCallback.REJECTED;
        }
        final ActionCallback result = new ActionCallback();
        ui.invokeLaterIfNeeded(false, new TreeRunnable("AbstractTreeBuilder.queueUpdateFrom"){

            @Override
            public void perform() {
                AbstractTreeUi ui = AbstractTreeBuilder.this.getUi();
                if (ui == null) {
                    result.reject("ui is null");
                    return;
                }
                if (updateStructure && forceResort) {
                    ui.incComparatorStamp();
                }
                ui.queueUpdate(element, updateStructure).notify(result);
            }
        });
        return result;
    }

    @Deprecated
    public void buildNodeForElement(@NotNull Object element) {
        AbstractTreeUi ui = this.getUi();
        if (ui != null) {
            ui.buildNodeForElement(element);
        }
    }

    @Deprecated
    @Nullable
    public DefaultMutableTreeNode getNodeForElement(@NotNull Object element) {
        AbstractTreeUi ui = this.getUi();
        return ui == null ? null : ui.getNodeForElement(element, false);
    }

    public void cleanUp() {
        AbstractTreeUi ui = this.getUi();
        if (ui != null) {
            ui.doCleanUp();
        }
    }

    @Nullable
    protected ProgressIndicator createProgressIndicator() {
        return null;
    }

    protected void expandNodeChildren(@NotNull DefaultMutableTreeNode node) {
        AbstractTreeUi ui = this.getUi();
        if (ui != null) {
            ui.doExpandNodeChildren(node);
        }
    }

    protected boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
        return !this.isDisposed() && this.getRootElement() == this.getTreeStructureElement(nodeDescriptor);
    }

    protected boolean isAlwaysShowPlus(NodeDescriptor descriptor) {
        return false;
    }

    protected boolean isSmartExpand() {
        return true;
    }

    public final boolean isDisposed() {
        return this.getUi() == null;
    }

    final boolean wasRootNodeInitialized() {
        AbstractTreeUi ui = this.getUi();
        return ui != null && ui.wasRootNodeInitialized();
    }

    public final boolean isNodeBeingBuilt(TreePath path2) {
        AbstractTreeUi ui = this.getUi();
        return ui != null && ui.isNodeBeingBuilt(path2);
    }

    @Nullable
    protected Object findNodeByElement(@NotNull Object element) {
        AbstractTreeUi ui = this.getUi();
        return ui == null ? null : ui.findNodeByElement(element);
    }

    public static boolean isLoadingNode(DefaultMutableTreeNode node) {
        return AbstractTreeUi.isLoadingNode(node);
    }

    void runOnYieldingDone(@NotNull Runnable onDone) {
        AbstractTreeUi ui = this.getUi();
        if (ui == null) {
            return;
        }
        if (ui.isPassthroughMode() || SwingUtilities.isEventDispatchThread()) {
            onDone.run();
        } else {
            EdtExecutorService.getInstance().execute(() -> {
                if (!this.isDisposed()) {
                    onDone.run();
                }
            });
        }
    }

    protected void yieldToEDT(@NotNull Runnable runnable) {
        AbstractTreeUi ui = this.getUi();
        if (ui == null) {
            return;
        }
        if (ui.isPassthroughMode()) {
            runnable.run();
        } else {
            EdtExecutorService.getInstance().execute(() -> {
                if (!this.isDisposed()) {
                    runnable.run();
                }
            });
        }
    }

    public boolean isToEnsureSelectionOnFocusGained() {
        return true;
    }

    protected void runBackgroundLoading(final @NotNull Runnable runnable) {
        if (this.isDisposed()) {
            return;
        }
        Application app = ApplicationManager.getApplication();
        if (app != null) {
            app.runReadAction(new TreeRunnable("AbstractTreeBuilder.runBackgroundLoading"){

                @Override
                public void perform() {
                    runnable.run();
                }
            });
        } else {
            runnable.run();
        }
    }

    protected void updateAfterLoadedInBackground(@NotNull Runnable runnable) {
        AbstractTreeUi ui = this.getUi();
        if (ui == null) {
            return;
        }
        if (ui.isPassthroughMode()) {
            runnable.run();
        } else {
            UIUtil.invokeLaterIfNeeded((Runnable)runnable);
        }
    }

    @NotNull
    public final ActionCallback getInitialized() {
        AbstractTreeUi ui = this.getUi();
        return ui == null ? ActionCallback.REJECTED : ui.getInitialized();
    }

    @NotNull
    public final ActionCallback getReady(Object requestor) {
        AbstractTreeUi ui = this.getUi();
        return ui == null ? ActionCallback.REJECTED : ui.getReady(requestor);
    }

    protected void sortChildren(Comparator<? super TreeNode> nodeComparator, DefaultMutableTreeNode node, List<? extends TreeNode> children) {
        children.sort(nodeComparator);
    }

    public void setPassthroughMode(boolean passthrough) {
        AbstractTreeUi ui = this.getUi();
        if (ui != null) {
            ui.setPassthroughMode(passthrough);
        }
    }

    public void expandAll(@Nullable Runnable onDone) {
        AbstractTreeUi ui = this.getUi();
        if (ui != null) {
            ui.expandAll(onDone);
        }
    }

    @NotNull
    public ActionCallback cancelUpdate() {
        AbstractTreeUi ui = this.getUi();
        return ui == null ? ActionCallback.REJECTED : ui.cancelUpdate();
    }

    @NotNull
    public ActionCallback batch(@NotNull Progressive progressive) {
        AbstractTreeUi ui = this.getUi();
        return ui == null ? ActionCallback.REJECTED : ui.batch(progressive);
    }

    @NotNull
    public Promise<Object> revalidateElement(@NotNull Object element) {
        AbstractTreeStructure structure = this.getTreeStructure();
        if (structure == null) {
            return Promises.rejectedPromise();
        }
        AsyncPromise promise = new AsyncPromise();
        structure.revalidateElement(element).doWhenDone(o -> promise.setResult(o)).doWhenRejected(s -> promise.setError(s));
        return promise;
    }

    public final AbstractTreeUi getUi() {
        AbstractTreeUi ui = this.myUi;
        return ui == null || ui.isReleaseRequested() ? null : ui;
    }

    public void dispose() {
        AbstractTreeUi ui = this.getUi();
        if (ui != null) {
            ui.requestRelease();
        }
    }

    void releaseUi() {
        this.myUi = null;
    }

    protected boolean updateNodeDescriptor(@NotNull NodeDescriptor descriptor) {
        AbstractTreeUi ui = this.getUi();
        return ui != null && descriptor.update();
    }

    @Nullable
    public final DefaultTreeModel getTreeModel() {
        AbstractTreeUi ui = this.getUi();
        return ui == null ? null : ui.getTreeModel();
    }

    @NotNull
    public final Set<Object> getSelectedElements() {
        AbstractTreeUi ui = this.getUi();
        return ui == null ? Collections.emptySet() : ui.getSelectedElements();
    }

    @NotNull
    public final <T> Set<T> getSelectedElements(@NotNull Class<T> elementClass) {
        LinkedHashSet<Object> result = new LinkedHashSet<Object>();
        for (Object o : this.getSelectedElements()) {
            Object each = this.transformElement(o);
            if (!elementClass.isInstance(each)) continue;
            result.add(each);
        }
        return result;
    }

    protected Object transformElement(Object object) {
        return object;
    }

    public final void setCanYieldUpdate(boolean yield) {
        AbstractTreeUi ui = this.getUi();
        if (ui != null) {
            ui.setCanYield(yield);
        }
    }

    @Nullable
    public static AbstractTreeBuilder getBuilderFor(@NotNull JTree tree) {
        Reference ref = (Reference)tree.getClientProperty(TREE_BUILDER);
        return (AbstractTreeBuilder)SoftReference.dereference((Reference)ref);
    }

    @Nullable
    public final <T> Object accept(@NotNull Class<?> nodeClass, @NotNull TreeVisitor<T> visitor) {
        return this.accept(nodeClass, this.getRootElement(), visitor);
    }

    @Nullable
    private <T> Object accept(@NotNull Class<?> nodeClass, Object element, @NotNull TreeVisitor<T> visitor) {
        Object[] children;
        if (element == null) {
            return null;
        }
        AbstractTreeStructure structure = this.getTreeStructure();
        if (structure == null) {
            return null;
        }
        if (nodeClass.isAssignableFrom(element.getClass()) && visitor.visit(element)) {
            return element;
        }
        for (Object each : children = structure.getChildElements(element)) {
            Object childObject = this.accept(nodeClass, each, visitor);
            if (childObject == null) continue;
            return childObject;
        }
        return null;
    }

    public <T> boolean select(@NotNull Class nodeClass, @NotNull TreeVisitor<T> visitor, @Nullable Runnable onDone, boolean addToSelection) {
        Object element = this.accept(nodeClass, visitor);
        if (element != null) {
            this.select(element, onDone, addToSelection);
            return true;
        }
        return false;
    }

    public void scrollSelectionToVisible(@Nullable Runnable onDone, boolean shouldBeCentered) {
        AbstractTreeUi ui = this.getUi();
        if (ui != null) {
            ui.scrollSelectionToVisible(onDone, shouldBeCentered);
        }
    }

    private static boolean isUnitTestingMode() {
        Application app = ApplicationManager.getApplication();
        return app != null && app.isUnitTestMode();
    }

    public static boolean isToPaintSelection(@NotNull JTree tree) {
        AbstractTreeBuilder builder = AbstractTreeBuilder.getBuilderFor(tree);
        return builder == null || builder.getUi() == null || builder.getUi().isToPaintSelection();
    }

    public boolean isSelectionBeingAdjusted() {
        AbstractTreeUi ui = this.getUi();
        return ui != null && ui.isSelectionBeingAdjusted();
    }

    public boolean isToBuildChildrenInBackground(Object element) {
        AbstractTreeUi ui = this.getUi();
        return ui != null && ui.isToBuildChildrenInBackground(element);
    }

    public final boolean isConsistent() {
        AbstractTreeUi ui = this.getUi();
        return ui != null && ui.isConsistent();
    }

    class UserRunnable
    implements Runnable {
        private final Runnable myRunnable;

        UserRunnable(Runnable runnable) {
            this.myRunnable = runnable;
        }

        @Override
        public void run() {
            if (this.myRunnable != null) {
                AbstractTreeUi ui = AbstractTreeBuilder.this.getUi();
                if (ui != null) {
                    ui.executeUserRunnable(this.myRunnable);
                } else {
                    this.myRunnable.run();
                }
            }
        }
    }

    private static class AbstractTreeNodeWrapper
    extends AbstractTreeNode<Object> {
        AbstractTreeNodeWrapper() {
            super(null, TREE_WRAPPER_VALUE);
        }

        @Override
        @NotNull
        public Collection<AbstractTreeNode<?>> getChildren() {
            return Collections.emptyList();
        }

        @Override
        public void update(@NotNull PresentationData presentation) {
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            return object instanceof AbstractTreeNode && Comparing.equal((Object)this.getEqualityObject(), (Object)((AbstractTreeNode)object).getEqualityObject());
        }
    }
}

