/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditSourceUtil {
    private EditSourceUtil() {
    }

    @Nullable
    public static Navigatable getDescriptor(@NotNull PsiElement element) {
        PsiElement original = EditSourceUtil.getNavigatableOriginalElement(element);
        if (original != null) {
            element = original;
        } else if (!EditSourceUtil.canNavigate(element)) {
            return null;
        }
        if (element instanceof PomTargetPsiElement) {
            return ((PomTargetPsiElement)element).getTarget();
        }
        PsiElement navigationElement = element.getNavigationElement();
        if (navigationElement instanceof PomTargetPsiElement) {
            return ((PomTargetPsiElement)navigationElement).getTarget();
        }
        int offset = navigationElement instanceof PsiFile ? -1 : navigationElement.getTextOffset();
        VirtualFile virtualFile2 = PsiUtilCore.getVirtualFile(navigationElement);
        if (virtualFile2 == null || !virtualFile2.isValid()) {
            return null;
        }
        OpenFileDescriptor desc = new OpenFileDescriptor(navigationElement.getProject(), virtualFile2, offset);
        desc.setUseCurrentWindow(FileEditorManager.USE_CURRENT_WINDOW.isIn((UserDataHolder)navigationElement));
        return desc;
    }

    private static PsiElement getNavigatableOriginalElement(@NotNull PsiElement element) {
        return EditSourceUtil.processAllOriginalElements(element, original -> EditSourceUtil.canNavigate(original) ? original : null);
    }

    public static boolean canNavigate(PsiElement element) {
        if (element == null || !element.isValid()) {
            return false;
        }
        VirtualFile file = PsiUtilCore.getVirtualFile(element.getNavigationElement());
        return file != null && file.isValid() && !file.is(VFileProperty.SPECIAL) && !VfsUtilCore.isBrokenLink(file);
    }

    public static void navigate(@NotNull NavigationItem item, boolean requestFocus, boolean useCurrentWindow) {
        if (item instanceof UserDataHolder) {
            ((UserDataHolder)item).putUserData(FileEditorManager.USE_CURRENT_WINDOW, (Object)useCurrentWindow);
        }
        item.navigate(requestFocus);
        if (item instanceof UserDataHolder) {
            ((UserDataHolder)item).putUserData(FileEditorManager.USE_CURRENT_WINDOW, null);
        }
    }

    private static PsiElement processAllOriginalElements(@NotNull PsiElement element, @NotNull Function<? super PsiElement, ? extends PsiElement> processor) {
        for (GeneratedSourcesFilter filter : (GeneratedSourcesFilter[])GeneratedSourcesFilter.EP_NAME.getExtensions()) {
            for (PsiElement psiElement : filter.getOriginalElements(element)) {
                PsiElement apply = processor.apply(psiElement);
                if (apply == null) continue;
                return apply;
            }
        }
        return null;
    }
}

