/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TextEditorBasedStructureViewModel;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructureViewModelBase
extends TextEditorBasedStructureViewModel {
    private final StructureViewTreeElement myRoot;
    private Sorter[] mySorters = Sorter.EMPTY_ARRAY;
    private Class[] mySuitableClasses = null;

    public StructureViewModelBase(@NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull StructureViewTreeElement root) {
        super(editor, psiFile);
        this.myRoot = root;
    }

    public StructureViewModelBase(@NotNull PsiFile psiFile, @NotNull StructureViewTreeElement root) {
        this(psiFile, null, root);
    }

    @Override
    @NotNull
    public StructureViewTreeElement getRoot() {
        return this.myRoot;
    }

    @NotNull
    public StructureViewModelBase withSorters(Sorter ... sorters) {
        this.mySorters = sorters;
        return this;
    }

    @NotNull
    public StructureViewModelBase withSuitableClasses(Class ... suitableClasses) {
        this.mySuitableClasses = suitableClasses;
        return this;
    }

    @Override
    public Sorter @NotNull [] getSorters() {
        return this.mySorters;
    }

    @Override
    protected Class @NotNull [] getSuitableClasses() {
        if (this.mySuitableClasses != null) {
            return this.mySuitableClasses;
        }
        return super.getSuitableClasses();
    }
}

