/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit;

import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.fileTypes.FileNameMatcherFactory;

public class LightEditFilePatterns {
    public static final String[] DEFAULT_PATTERNS = new String[]{"*.txt", "*.log", "*.md", "*.json", "*.xml", "*.sh", "*.ini", "*.yml", "*.conf"};
    public static final String PATTERN_SEPARATOR = ";";
    private final Set<String> myPatterns = new HashSet<String>();
    private final Object myPatternLock = new Object();
    private volatile List<FileNameMatcher> myMatchers = null;

    public LightEditFilePatterns() {
        this(Arrays.asList(DEFAULT_PATTERNS));
    }

    private LightEditFilePatterns(@NotNull List<String> filePatterns) {
        this.myPatterns.addAll(filePatterns);
    }

    public static LightEditFilePatterns parse(@NotNull String patternString) {
        ArrayList<String> filePatterns = new ArrayList<String>();
        for (String pattern : patternString.split(PATTERN_SEPARATOR)) {
            if (StringUtil.isEmptyOrSpaces((String)pattern)) continue;
            filePatterns.add(pattern);
        }
        return new LightEditFilePatterns(filePatterns);
    }

    public String toSeparatedString() {
        return String.join((CharSequence)PATTERN_SEPARATOR, this.getPatterns());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<String> getPatterns() {
        Object object = this.myPatternLock;
        synchronized (object) {
            return this.myPatterns.stream().sorted().collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPatterns(@NotNull List<String> patterns) {
        Object object = this.myPatternLock;
        synchronized (object) {
            this.myPatterns.clear();
            this.myPatterns.addAll(patterns);
            this.myMatchers = null;
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof LightEditFilePatterns && this.getPatterns().equals(((LightEditFilePatterns)obj).getPatterns());
    }

    public int hashCode() {
        return this.getPatterns().hashCode();
    }

    public boolean match(@NotNull VirtualFile file) {
        for (FileNameMatcher matcher : this.getMatchers()) {
            if (!matcher.acceptsCharSequence(file.getNameSequence())) continue;
            return true;
        }
        return false;
    }

    private List<FileNameMatcher> getMatchers() {
        List matchers = this.myMatchers;
        if (matchers == null) {
            this.myMatchers = matchers = ContainerUtil.map(this.getPatterns(), pattern -> FileNameMatcherFactory.getInstance().createMatcher((String)pattern));
        }
        return matchers;
    }
}

