/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ide.browsers.BrowserLauncherAppless;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BrowserUtil {
    private static final Pattern ourExternalPrefix = Pattern.compile("^[\\w+.\\-]{2,}:");
    private static final Pattern ourAnchorSuffix = Pattern.compile("#(.*)$");

    private BrowserUtil() {
    }

    public static boolean isAbsoluteURL(String url) {
        return ourExternalPrefix.matcher(StringUtil.toLowerCase((String)url)).find();
    }

    public static String getDocURL(String url) {
        Matcher anchorMatcher = ourAnchorSuffix.matcher(url);
        return anchorMatcher.find() ? anchorMatcher.reset().replaceAll("") : url;
    }

    @Nullable
    public static URL getURL(String url) throws MalformedURLException {
        return BrowserUtil.isAbsoluteURL(url) ? VfsUtilCore.convertToURL(url) : new URL("file", "", url);
    }

    public static void open(@NotNull String url) {
        BrowserUtil.getBrowserLauncher().open(url);
    }

    public static void browse(@NotNull VirtualFile file) {
        BrowserUtil.browse(file.getUrl(), null);
    }

    public static void browse(@NotNull File file) {
        BrowserUtil.getBrowserLauncher().browse(file);
    }

    public static void browse(@NotNull URL url) {
        BrowserUtil.browse(url.toExternalForm(), null);
    }

    public static void browse(@NotNull URI uri) {
        BrowserUtil.getBrowserLauncher().browse(uri);
    }

    public static void browse(@NonNls @NotNull String url) {
        BrowserUtil.browse(url, null);
    }

    public static void browse(@NotNull String url, @Nullable Project project) {
        BrowserUtil.getBrowserLauncher().browse(url, null, project);
    }

    private static BrowserLauncher getBrowserLauncher() {
        return ApplicationManager.getApplication() != null ? BrowserLauncher.getInstance() : new BrowserLauncherAppless();
    }

    @NotNull
    public static List<String> getOpenBrowserCommand(@NotNull String browserPathOrName, boolean newWindowIfPossible) {
        if (new File(browserPathOrName).isFile()) {
            return Collections.singletonList(browserPathOrName);
        }
        if (SystemInfo.isMac) {
            ArrayList command = ContainerUtil.newArrayList((Object[])new String[]{ExecUtil.getOpenCommandPath(), "-a", browserPathOrName});
            if (newWindowIfPossible) {
                command.add("-n");
            }
            return command;
        }
        if (SystemInfo.isWindows) {
            return Arrays.asList(ExecUtil.getWindowsShellName(), "/c", "start", GeneralCommandLine.inescapableQuote((String)""), browserPathOrName);
        }
        return Collections.singletonList(browserPathOrName);
    }

    @NotNull
    public static String getDefaultAlternativeBrowserPath() {
        if (SystemInfo.isWindows) {
            return "C:\\Program Files\\Internet Explorer\\IExplore.exe";
        }
        if (SystemInfo.isMac) {
            return "open";
        }
        if (SystemInfo.isUnix) {
            return "/usr/bin/firefox";
        }
        return "";
    }

    @Deprecated
    public static void launchBrowser(@NotNull String url) {
        BrowserUtil.browse(url);
    }
}

