/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.featureStatistics;

import com.intellij.AbstractBundle;
import com.intellij.featureStatistics.FeatureStatisticsBundleEP;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.reference.SoftReference;
import java.lang.ref.Reference;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

public final class FeatureStatisticsBundle {
    private static Reference<ResourceBundle> ourBundle;
    private static final Logger LOG;
    @NonNls
    private static final String BUNDLE = "messages.FeatureStatisticsBundle";

    public static String message(@NotNull @PropertyKey(resourceBundle="messages.FeatureStatisticsBundle") String key, Object ... params) {
        return AbstractBundle.message((ResourceBundle)FeatureStatisticsBundle.getBundle(key), (String)key, (Object[])params);
    }

    private FeatureStatisticsBundle() {
    }

    private static ResourceBundle getBundle(String key) {
        ResourceBundle providerBundle = (ResourceBundle)ProvidersBundles.INSTANCE.get(key);
        if (providerBundle != null) {
            return providerBundle;
        }
        ResourceBundle bundle = (ResourceBundle)SoftReference.dereference(ourBundle);
        if (bundle == null) {
            bundle = ResourceBundle.getBundle(BUNDLE);
            ourBundle = new java.lang.ref.SoftReference<ResourceBundle>(bundle);
        }
        return bundle;
    }

    static {
        LOG = Logger.getInstance(FeatureStatisticsBundle.class);
    }

    private static final class ProvidersBundles
    extends HashMap<String, ResourceBundle> {
        private static final ProvidersBundles INSTANCE = new ProvidersBundles();

        private ProvidersBundles() {
            for (FeatureStatisticsBundleEP bundleEP : FeatureStatisticsBundleEP.EP_NAME.getExtensionList()) {
                try {
                    ResourceBundle bundle = ResourceBundle.getBundle(bundleEP.qualifiedName, Locale.getDefault(), bundleEP.getLoaderForClass());
                    for (String key : bundle.keySet()) {
                        this.put(key, bundle);
                    }
                }
                catch (MissingResourceException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
    }
}

