/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class CloseAction
extends AnAction
implements DumbAware {
    private RunContentDescriptor myContentDescriptor;
    private final Project myProject;
    private Executor myExecutor;

    public CloseAction(Executor executor, RunContentDescriptor contentDescriptor, Project project) {
        this.myExecutor = executor;
        this.myContentDescriptor = contentDescriptor;
        this.myProject = project;
        ActionUtil.copyFrom(this, "CloseContent");
        Presentation templatePresentation = this.getTemplatePresentation();
        templatePresentation.setIcon(AllIcons.Actions.Cancel);
        templatePresentation.setText(ExecutionBundle.messagePointer("close.tab.action.name", new Object[0]));
        templatePresentation.setDescription(Presentation.NULL_STRING);
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        this.perform();
    }

    public void perform() {
        RunContentDescriptor contentDescriptor = this.getContentDescriptor();
        if (contentDescriptor == null) {
            return;
        }
        boolean removedOk = RunContentManager.getInstance(this.myProject).removeRunContent(this.getExecutor(), contentDescriptor);
        if (removedOk) {
            this.myContentDescriptor = null;
            this.myExecutor = null;
        }
    }

    public RunContentDescriptor getContentDescriptor() {
        return this.myContentDescriptor;
    }

    public Executor getExecutor() {
        return this.myExecutor;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabled(this.myContentDescriptor != null);
    }
}

