/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ui.TagButton;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.IdeFocusManager;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SettingsEditorFragment<Settings, C extends JComponent>
extends SettingsEditor<Settings> {
    private final String myId;
    private final String myName;
    private final String myGroup;
    protected C myComponent;
    private final BiConsumer<Settings, C> myReset;
    private final BiConsumer<Settings, C> myApply;
    private final int myCommandLinePosition;
    private final Predicate<Settings> myInitialSelection;
    @Nullable
    private String myHint;
    @Nullable
    private JComponent myHintComponent;
    @Nullable
    private Function<C, JComponent> myEditorGetter;

    public SettingsEditorFragment(String id, @Nls(capitalization=Nls.Capitalization.Sentence) String name, @Nls(capitalization=Nls.Capitalization.Title) String group, C component, int commandLinePosition, BiConsumer<Settings, C> reset, BiConsumer<Settings, C> apply, Predicate<Settings> initialSelection) {
        this.myId = id;
        this.myName = name;
        this.myGroup = group;
        this.myComponent = component;
        this.myReset = reset;
        this.myApply = apply;
        this.myCommandLinePosition = commandLinePosition;
        this.myInitialSelection = initialSelection;
    }

    public SettingsEditorFragment(String id, @Nls(capitalization=Nls.Capitalization.Sentence) String name, @Nls(capitalization=Nls.Capitalization.Title) String group, C component, BiConsumer<Settings, C> reset, BiConsumer<Settings, C> apply, Predicate<Settings> initialSelection) {
        this(id, name, group, component, 0, reset, apply, initialSelection);
    }

    public static <S> SettingsEditorFragment<S, ?> createWrapper(String id, String name, String group, @NotNull SettingsEditor<S> inner) {
        JComponent component = inner.getComponent();
        SettingsEditorFragment<Object, JComponent> fragment = new SettingsEditorFragment<Object, JComponent>(id, name, group, component, (settings, c) -> inner.resetFrom(settings), (settings, c) -> {
            try {
                inner.applyTo(settings);
            }
            catch (ConfigurationException e) {
                throw new RuntimeException(e);
            }
        }, s -> false);
        Disposer.register(fragment, inner);
        return fragment;
    }

    public static <Settings> SettingsEditorFragment<Settings, ?> createTag(String id, String name, String group, Predicate<Settings> getter, BiConsumer<Settings, Boolean> setter) {
        Ref ref = new Ref();
        TagButton tagButton = new TagButton(name, () -> ((SettingsEditorFragment)ref.get()).setSelected(false));
        SettingsEditorFragment fragment = new SettingsEditorFragment<Settings, JComponent>(id, name, group, tagButton, (settings, button) -> button.setVisible(getter.test(settings)), (settings, button) -> setter.accept(settings, button.isVisible()), getter){

            @Override
            public boolean isTag() {
                return true;
            }
        };
        Disposer.register((Disposable)fragment, (Disposable)tagButton);
        ref.set((Object)fragment);
        return fragment;
    }

    public String getId() {
        return this.myId;
    }

    public String getName() {
        return this.myName;
    }

    public String getGroup() {
        return this.myGroup;
    }

    public C component() {
        return this.myComponent;
    }

    public boolean isTag() {
        return false;
    }

    public boolean isSelected() {
        return ((Component)this.myComponent).isVisible();
    }

    public boolean isInitiallyVisible(Settings settings) {
        return this.myInitialSelection.test(settings);
    }

    public void setSelected(boolean selected) {
        ((JComponent)this.myComponent).setVisible(selected);
        if (this.myHintComponent != null) {
            this.myHintComponent.setVisible(selected);
        }
        this.fireEditorStateChanged();
    }

    public void toggle(boolean selected) {
        this.setSelected(selected);
        if (selected) {
            IdeFocusManager.getGlobalInstance().requestFocus(this.getEditorComponent(), false);
        }
    }

    public void setEditorGetter(@Nullable Function<C, JComponent> editorGetter) {
        this.myEditorGetter = editorGetter;
    }

    protected JComponent getEditorComponent() {
        C component = this.component();
        if (this.myEditorGetter != null) {
            return this.myEditorGetter.apply(this.component());
        }
        return component instanceof LabeledComponent ? ((LabeledComponent)component).getComponent() : component;
    }

    public int getCommandLinePosition() {
        return this.myCommandLinePosition;
    }

    public int getMenuPosition() {
        return 0;
    }

    @Override
    protected void resetEditorFrom(@NotNull Settings s) {
        this.myReset.accept(s, this.myComponent);
    }

    @Override
    protected void applyEditorTo(@NotNull Settings s) throws ConfigurationException {
        this.myApply.accept(s, this.myComponent);
    }

    @Override
    @NotNull
    protected JComponent createEditor() {
        ((JComponent)this.myComponent).setVisible(this.isSelected());
        return this.myComponent;
    }

    public List<SettingsEditorFragment<Settings, ?>> getChildren() {
        return Collections.emptyList();
    }

    @Nullable
    public String getChildrenGroupName() {
        return null;
    }

    @Nullable
    public String getHint() {
        return this.myHint;
    }

    public void setHint(@Nullable String hint) {
        this.myHint = hint;
    }

    @Nullable
    public JComponent getHintComponent() {
        if (this.myHintComponent == null && this.myHint != null) {
            JLabel comment = ComponentPanelBuilder.createNonWrappingCommentComponent(this.myHint);
            comment.setFocusable(false);
            this.myHintComponent = LabeledComponent.create(comment, "", "West");
        }
        return this.myHintComponent;
    }

    public String toString() {
        return this.myId + " " + this.myName;
    }

    public static interface FragmentComponent<Settings> {
        public void reset(Settings var1);

        public void apply(Settings var1);

        public boolean isVisible(Settings var1);
    }
}

