/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.target;

import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.value.TargetValue;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TargetedCommandLineBuilder
extends UserDataHolderBase {
    @NotNull
    private TargetValue<String> myExePath = TargetValue.empty();
    @NotNull
    private TargetValue<String> myWorkingDirectory = TargetValue.empty();
    @NotNull
    private TargetValue<String> myInputFilePath = TargetValue.empty();
    @NotNull
    private Charset myCharset = CharsetToolkit.getDefaultSystemCharset();
    @NotNull
    private final List<TargetValue<String>> myParameters = new ArrayList<TargetValue<String>>();
    @NotNull
    private final Map<String, TargetValue<String>> myEnvironment = new HashMap<String, TargetValue<String>>();
    @NotNull
    private final Set<File> myFilesToDeleteOnTermination = new HashSet<File>();
    @NotNull
    private final TargetEnvironmentRequest myRequest;

    public TargetedCommandLineBuilder(@NotNull TargetEnvironmentRequest request) {
        this.myRequest = request;
    }

    @NotNull
    public TargetEnvironmentRequest getRequest() {
        return this.myRequest;
    }

    @NotNull
    public TargetedCommandLine build() {
        return new TargetedCommandLine(this.myExePath, this.myWorkingDirectory, this.myInputFilePath, this.myCharset, new ArrayList<TargetValue<String>>(this.myParameters), new HashMap<String, TargetValue<String>>(this.myEnvironment));
    }

    public void setCharset(@NotNull Charset charset) {
        this.myCharset = charset;
    }

    public void setExePath(@NotNull TargetValue<String> exePath) {
        this.myExePath = exePath;
    }

    public void setExePath(@NotNull String exePath) {
        this.myExePath = TargetValue.fixed(exePath);
    }

    public void setWorkingDirectory(@NotNull TargetValue<String> workingDirectory) {
        this.myWorkingDirectory = workingDirectory;
    }

    public void addParameter(@NotNull TargetValue<String> parameter) {
        this.myParameters.add(parameter);
    }

    public void addParameter(@NotNull String parameter) {
        this.myParameters.add(TargetValue.fixed(parameter));
    }

    public void addParameters(@NotNull List<String> parametersList) {
        for (String parameter : parametersList) {
            this.addParameter(parameter);
        }
    }

    public void addParameters(String ... parametersList) {
        for (String parameter : parametersList) {
            this.addParameter(parameter);
        }
    }

    public void addParameterAt(int index, @NotNull String parameter) {
        this.addParameterAt(index, TargetValue.fixed(parameter));
    }

    public void addParameterAt(int index, @NotNull TargetValue<String> parameter) {
        this.myParameters.add(index, parameter);
    }

    public void addEnvironmentVariable(@NotNull String name, @Nullable TargetValue<String> value) {
        if (value != null) {
            this.myEnvironment.put(name, value);
        } else {
            this.myEnvironment.remove(name);
        }
    }

    public void addEnvironmentVariable(@NotNull String name, @Nullable String value) {
        this.addEnvironmentVariable(name, value != null ? TargetValue.fixed(value) : null);
    }

    public void removeEnvironmentVariable(@NotNull String name) {
        this.myEnvironment.remove(name);
    }

    public void addFileToDeleteOnTermination(@NotNull File file) {
        this.myFilesToDeleteOnTermination.add(file);
    }

    public void setInputFile(@NotNull TargetValue<String> inputFilePath) {
        this.myInputFilePath = inputFilePath;
    }

    @NotNull
    public Set<File> getFilesToDeleteOnTermination() {
        return this.myFilesToDeleteOnTermination;
    }
}

