/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;

public interface LineNumbersMapping {
    public static final Key<LineNumbersMapping> LINE_NUMBERS_MAPPING_KEY = Key.create((String)"line.numbers.mapping.key");

    public int bytecodeToSource(int var1);

    public int sourceToBytecode(int var1);

    public static class ArrayBasedMapping
    implements LineNumbersMapping {
        private final int[] myMapping;

        public ArrayBasedMapping(int @NotNull [] mapping) {
            this.myMapping = (int[])mapping.clone();
        }

        @Override
        public int bytecodeToSource(int line) {
            for (int i = 0; i < this.myMapping.length; i += 2) {
                if (this.myMapping[i] != line) continue;
                return this.myMapping[i + 1];
            }
            return -1;
        }

        @Override
        public int sourceToBytecode(int line) {
            for (int i = 0; i < this.myMapping.length; i += 2) {
                if (this.myMapping[i + 1] != line) continue;
                return this.myMapping[i];
            }
            return -1;
        }
    }
}

