/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.diagnostic.PluginException;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.FilterMixin;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeFilter
implements Filter,
FilterMixin,
DumbAware {
    private static final Logger LOG = Logger.getInstance(CompositeFilter.class);
    private final List<Filter> myFilters;
    private boolean myIsAnyHeavy;
    private boolean forceUseAllFilters;
    private final DumbService myDumbService;

    public CompositeFilter(@NotNull Project project) {
        this(project, Collections.emptyList());
    }

    public CompositeFilter(@NotNull Project project, @NotNull List<? extends Filter> filters) {
        this.myDumbService = DumbService.getInstance(project);
        this.myFilters = new ArrayList<Filter>(filters);
        this.myFilters.forEach(filter -> this.myIsAnyHeavy |= filter instanceof FilterMixin);
    }

    protected CompositeFilter(@NotNull DumbService dumbService) {
        this.myDumbService = dumbService;
        this.myFilters = new ArrayList<Filter>();
    }

    @Override
    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        boolean dumb = this.myDumbService.isDumb();
        List<Filter> filters = this.myFilters;
        int count = filters.size();
        List<Filter.ResultItem> resultItems = null;
        for (int i = 0; i < count; ++i) {
            Filter.Result result;
            ProgressManager.checkCanceled();
            Filter filter = filters.get(i);
            if (dumb && !DumbService.isDumbAware(filter)) continue;
            long t0 = System.currentTimeMillis();
            try {
                result = filter.applyFilter(line, entireLength);
            }
            catch (ProcessCanceledException ignore) {
                result = null;
            }
            catch (Throwable t) {
                throw new RuntimeException("Error while applying " + filter + " to '" + line + "'", t);
            }
            if (result != null) {
                try {
                    resultItems = CompositeFilter.merge(resultItems, result, entireLength, filter);
                }
                catch (ProcessCanceledException ignore) {
                    return null;
                }
                catch (Throwable t) {
                    throw new ApplyFilterException("Error while merging results from " + filter, t);
                }
            }
            if ((t0 = System.currentTimeMillis() - t0) > 1000L) {
                LOG.warn(filter.getClass().getSimpleName() + ".applyFilter() took " + t0 + " ms on '''" + line + "'''");
            }
            if (result != null && this.shouldStopFiltering(result)) break;
        }
        if (resultItems == null) {
            return null;
        }
        return CompositeFilter.createFinalResult(resultItems);
    }

    @NotNull
    private static Filter.Result createFinalResult(@NotNull List<? extends Filter.ResultItem> resultItems) {
        if (resultItems.size() == 1) {
            final Filter.ResultItem resultItem = resultItems.get(0);
            return new Filter.Result(resultItem.getHighlightStartOffset(), resultItem.getHighlightEndOffset(), resultItem.getHyperlinkInfo(), resultItem.getHighlightAttributes(), resultItem.getFollowedHyperlinkAttributes()){

                @Override
                public int getHighlighterLayer() {
                    return resultItem.getHighlighterLayer();
                }
            };
        }
        return new Filter.Result(resultItems);
    }

    private boolean shouldStopFiltering(@NotNull Filter.Result result) {
        return result.getNextAction() == Filter.NextAction.EXIT && !this.forceUseAllFilters;
    }

    @NotNull
    private static List<Filter.ResultItem> merge(@Nullable List<Filter.ResultItem> resultItems, @NotNull Filter.Result newResult, int entireLength, @NotNull Filter filter) {
        if (resultItems == null) {
            resultItems = new ArrayList<Filter.ResultItem>();
        }
        List<Filter.ResultItem> newItems = newResult.getResultItems();
        for (int i = 0; i < newItems.size(); ++i) {
            Filter.ResultItem item = newItems.get(i);
            if (item.getHyperlinkInfo() != null && CompositeFilter.intersects(resultItems, item) || !CompositeFilter.checkOffsetsCorrect(item, entireLength, filter)) continue;
            resultItems.add(item);
        }
        return resultItems;
    }

    private static boolean checkOffsetsCorrect(@NotNull Filter.ResultItem item, int entireLength, @NotNull Filter filter) {
        int start = item.getHighlightStartOffset();
        int end = item.getHighlightEndOffset();
        if (end < start || end > entireLength) {
            String message = "Filter returned wrong range: start=" + start + "; end=" + end + "; length=" + entireLength + "; filter=" + filter;
            PluginException.logPluginError(LOG, message, null, filter.getClass());
            return false;
        }
        return true;
    }

    protected static boolean intersects(@NotNull List<? extends Filter.ResultItem> items, @NotNull Filter.ResultItem newItem) {
        TextRange newItemTextRange = null;
        for (int i = 0; i < items.size(); ++i) {
            Filter.ResultItem item = items.get(i);
            if (item.getHyperlinkInfo() == null) continue;
            if (newItemTextRange == null) {
                newItemTextRange = new TextRange(newItem.getHighlightStartOffset(), newItem.getHighlightEndOffset());
            }
            if (!newItemTextRange.intersectsStrict(item.getHighlightStartOffset(), item.getHighlightEndOffset())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldRunHeavy() {
        for (Filter filter : this.myFilters) {
            if (!(filter instanceof FilterMixin) || !((FilterMixin)((Object)filter)).shouldRunHeavy()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void applyHeavyFilter(@NotNull Document copiedFragment, int startOffset, int startLineNumber, @NotNull Consumer<? super FilterMixin.AdditionalHighlight> consumer) {
        List<Filter> filters = this.myFilters;
        int count = filters.size();
        for (int i = 0; i < count; ++i) {
            Filter filter = filters.get(i);
            if (!(filter instanceof FilterMixin) || !((FilterMixin)((Object)filter)).shouldRunHeavy()) continue;
            ((FilterMixin)((Object)filter)).applyHeavyFilter(copiedFragment, startOffset, startLineNumber, consumer);
        }
    }

    @Override
    @NotNull
    public String getUpdateMessage() {
        List<Filter> filters = this.myFilters;
        ArrayList<String> updateMessage = new ArrayList<String>();
        int count = filters.size();
        for (int i = 0; i < count; ++i) {
            Filter filter = filters.get(i);
            if (!(filter instanceof FilterMixin) || !((FilterMixin)((Object)filter)).shouldRunHeavy()) continue;
            updateMessage.add(((FilterMixin)((Object)filter)).getUpdateMessage());
        }
        return updateMessage.size() == 1 ? (String)updateMessage.get(0) : "Updating...";
    }

    public boolean isEmpty() {
        return this.myFilters.isEmpty();
    }

    public boolean isAnyHeavy() {
        return this.myIsAnyHeavy;
    }

    public void addFilter(@NotNull Filter filter) {
        this.myFilters.add(filter);
        this.myIsAnyHeavy |= filter instanceof FilterMixin;
    }

    @NotNull
    public List<Filter> getFilters() {
        return Collections.unmodifiableList(this.myFilters);
    }

    public void setForceUseAllFilters(boolean forceUseAllFilters) {
        this.forceUseAllFilters = forceUseAllFilters;
    }

    public String toString() {
        return "CompositeFilter: " + this.myFilters;
    }

    public static class ApplyFilterException
    extends RuntimeException {
        private ApplyFilterException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

