/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.RunConfigurationProducerService;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.ConfigurationFromContextImpl;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RunConfigurationProducer<T extends RunConfiguration> {
    public static final ExtensionPointName<RunConfigurationProducer> EP_NAME = ExtensionPointName.create((String)"com.intellij.runConfigurationProducer");
    private static final Logger LOG = Logger.getInstance(RunConfigurationProducer.class);
    private final ConfigurationFactory myConfigurationFactory;

    @NotNull
    public static List<RunConfigurationProducer<?>> getProducers(@NotNull Project project) {
        RunConfigurationProducerService runConfigurationProducerService = RunConfigurationProducerService.getInstance(project);
        List allProducers = EP_NAME.getExtensionList();
        ArrayList result = new ArrayList(allProducers.size());
        for (RunConfigurationProducer producer : allProducers) {
            if (runConfigurationProducerService.isIgnored(producer)) continue;
            result.add(producer);
        }
        return result;
    }

    @Deprecated
    protected RunConfigurationProducer(@NotNull ConfigurationFactory configurationFactory) {
        this.myConfigurationFactory = configurationFactory;
    }

    @Deprecated
    protected RunConfigurationProducer(@NotNull Class<? extends ConfigurationType> type) {
        this(ConfigurationTypeUtil.findConfigurationType(type));
    }

    public RunConfigurationProducer(boolean internalUsageOnly) {
        this.myConfigurationFactory = null;
    }

    @Deprecated
    protected RunConfigurationProducer(@NotNull ConfigurationType configurationType) {
        this.myConfigurationFactory = configurationType.getConfigurationFactories()[0];
    }

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        return this.myConfigurationFactory;
    }

    @NotNull
    public final ConfigurationType getConfigurationType() {
        return this.getConfigurationFactory().getType();
    }

    @Nullable
    public ConfigurationFromContext createConfigurationFromContext(@NotNull ConfigurationContext context) {
        RunnerAndConfigurationSettings settings = this.cloneTemplateConfiguration(context);
        Ref ref = new Ref((Object)context.getPsiLocation());
        try {
            if (!this.setupConfigurationFromContext(settings.getConfiguration(), context, (Ref<PsiElement>)ref)) {
                return null;
            }
        }
        catch (ClassCastException e) {
            LOG.error(this.getConfigurationFactory() + " produced wrong type", (Throwable)e);
            return null;
        }
        catch (ProcessCanceledException | IndexNotReadyException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            return null;
        }
        return new ConfigurationFromContextImpl(this, settings, (PsiElement)ref.get());
    }

    protected abstract boolean setupConfigurationFromContext(@NotNull T var1, @NotNull ConfigurationContext var2, @NotNull Ref<PsiElement> var3);

    public abstract boolean isConfigurationFromContext(@NotNull T var1, @NotNull ConfigurationContext var2);

    public boolean isPreferredConfiguration(ConfigurationFromContext self, ConfigurationFromContext other) {
        return true;
    }

    public boolean shouldReplace(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        return false;
    }

    public void onFirstRun(@NotNull ConfigurationFromContext configuration, @NotNull ConfigurationContext context, @NotNull Runnable startRunnable) {
        startRunnable.run();
    }

    @Nullable
    public ConfigurationFromContext findOrCreateConfigurationFromContext(@NotNull ConfigurationContext context) {
        Location location = context.getLocation();
        if (location == null) {
            return null;
        }
        ConfigurationFromContext fromContext = this.createConfigurationFromContext(context);
        if (fromContext == null) {
            return null;
        }
        PsiElement psiElement = fromContext.getSourceElement();
        Location<PsiElement> _location = PsiLocation.fromPsiElement(psiElement, location.getModule());
        if (_location != null) {
            RunnerAndConfigurationSettings settings = this.findExistingConfiguration(context);
            if (settings == null) {
                RunManager.getInstance(context.getProject()).setUniqueNameIfNeeded(fromContext.getConfiguration());
            } else {
                fromContext.setConfigurationSettings(settings);
            }
        }
        return fromContext;
    }

    @Nullable
    public RunnerAndConfigurationSettings findExistingConfiguration(@NotNull ConfigurationContext context) {
        RunManager runManager = RunManager.getInstance(context.getProject());
        List<RunnerAndConfigurationSettings> configurations = this.getConfigurationSettingsList(runManager);
        for (RunnerAndConfigurationSettings configurationSettings : configurations) {
            ProgressManager.checkCanceled();
            if (!this.isConfigurationFromContext(configurationSettings.getConfiguration(), context)) continue;
            return configurationSettings;
        }
        return null;
    }

    @NotNull
    protected List<RunnerAndConfigurationSettings> getConfigurationSettingsList(@NotNull RunManager runManager) {
        return runManager.getConfigurationSettingsList(this.getConfigurationFactory().getType());
    }

    protected RunnerAndConfigurationSettings cloneTemplateConfiguration(@NotNull ConfigurationContext context) {
        return RunConfigurationProducer.cloneTemplateConfigurationStatic(context, this.getConfigurationFactory());
    }

    @NotNull
    protected static RunnerAndConfigurationSettings cloneTemplateConfigurationStatic(@NotNull ConfigurationContext context, @NotNull ConfigurationFactory configurationFactory) {
        RunConfiguration original = context.getOriginalConfiguration(configurationFactory.getType());
        if (original != null) {
            return RunManager.getInstance(context.getProject()).createConfiguration(original.clone(), configurationFactory);
        }
        return RunManager.getInstance(context.getProject()).createConfiguration("", configurationFactory);
    }

    @NotNull
    public static <T extends RunConfigurationProducer> T getInstance(@NotNull Class<? extends T> aClass) {
        for (RunConfigurationProducer producer : EP_NAME.getExtensionList()) {
            if (!aClass.isInstance(producer)) continue;
            return (T)producer;
        }
        assert (false) : aClass;
        return null;
    }

    @Nullable
    public RunConfiguration createLightConfiguration(@NotNull ConfigurationContext context) {
        RunConfiguration configuration = this.getConfigurationFactory().createTemplateConfiguration(context.getProject());
        Ref ref = new Ref((Object)context.getPsiLocation());
        try {
            if (!this.setupConfigurationFromContext(configuration, context, (Ref<PsiElement>)ref)) {
                return null;
            }
        }
        catch (ClassCastException e) {
            LOG.error(this.getConfigurationFactory() + " produced wrong type", (Throwable)e);
            return null;
        }
        return configuration;
    }
}

