/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.TextWithMnemonic;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Executor {
    public static final ExtensionPointName<Executor> EXECUTOR_EXTENSION_NAME = ExtensionPointName.create((String)"com.intellij.executor");

    @NotNull
    public abstract String getToolWindowId();

    @NotNull
    public abstract Icon getToolWindowIcon();

    @NotNull
    public abstract Icon getIcon();

    public abstract Icon getDisabledIcon();

    public abstract @NlsActions.ActionDescription String getDescription();

    @NotNull
    public abstract @NlsActions.ActionText String getActionName();

    @NotNull
    @NonNls
    public abstract String getId();

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Title)
    public abstract String getStartActionText();

    @NonNls
    public abstract String getContextActionId();

    @NonNls
    public abstract String getHelpId();

    @Nullable
    public ActionWrapper runnerActionsGroupExecutorActionCustomizer() {
        return null;
    }

    @NotNull
    public String getStartActionText(@NotNull String configurationName) {
        String configName = StringUtil.isEmpty((String)configurationName) ? "" : " '" + Executor.shortenNameIfNeeded(configurationName) + "'";
        return TextWithMnemonic.parse((String)this.getStartActionText()).append(configName).toString();
    }

    public boolean isApplicable(@NotNull Project project) {
        return true;
    }

    public static String shortenNameIfNeeded(@NotNull String name) {
        return StringUtil.trimMiddle((String)name, (int)Registry.intValue((String)"run.configuration.max.name.length", (int)80));
    }

    @Deprecated
    public static String shortenNameIfNeed(@NotNull String name) {
        return Executor.shortenNameIfNeeded(name);
    }

    @FunctionalInterface
    public static interface ActionWrapper {
        @NotNull
        public AnAction wrap(@NotNull AnAction var1);
    }
}

