/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ReflectionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LocalQuickFixOnPsiElement
implements LocalQuickFix,
Cloneable {
    protected static final Logger LOG = Logger.getInstance(LocalQuickFixOnPsiElement.class);
    @FileModifier.SafeFieldForPreview
    protected final SmartPsiElementPointer<PsiElement> myStartElement;
    @FileModifier.SafeFieldForPreview
    protected final SmartPsiElementPointer<PsiElement> myEndElement;

    protected LocalQuickFixOnPsiElement(@NotNull PsiElement element) {
        this(element, element);
    }

    public LocalQuickFixOnPsiElement(PsiElement startElement, PsiElement endElement) {
        PsiFile endContainingFile;
        if (startElement == null || endElement == null) {
            this.myEndElement = null;
            this.myStartElement = null;
            return;
        }
        LOG.assertTrue(startElement.isValid());
        PsiFile startContainingFile = startElement.getContainingFile();
        PsiFile psiFile = endContainingFile = startElement == endElement ? startContainingFile : endElement.getContainingFile();
        if (startElement != endElement) {
            LOG.assertTrue(endElement.isValid());
            LOG.assertTrue(startContainingFile == endContainingFile, (Object)"Both elements must be from the same file");
        }
        Project project = startContainingFile == null ? startElement.getProject() : startContainingFile.getProject();
        this.myStartElement = SmartPointerManager.getInstance(project).createSmartPsiElementPointer(startElement, startContainingFile);
        this.myEndElement = endElement == startElement ? null : SmartPointerManager.getInstance(project).createSmartPsiElementPointer(endElement, endContainingFile);
    }

    @Override
    @NotNull
    public final String getName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        return true;
    }

    protected boolean isAvailable() {
        if (this.myStartElement == null) {
            return false;
        }
        PsiElement startElement = this.myStartElement.getElement();
        PsiElement endElement = this.myEndElement == null ? startElement : this.myEndElement.getElement();
        PsiFile file = this.myStartElement.getContainingFile();
        Project project = this.myStartElement.getProject();
        return startElement != null && endElement != null && file != null && this.isAvailable(project, file, startElement, endElement);
    }

    public PsiElement getStartElement() {
        return this.myStartElement == null ? null : this.myStartElement.getElement();
    }

    public PsiElement getEndElement() {
        return this.myEndElement == null ? null : this.myEndElement.getElement();
    }

    public abstract @IntentionName @NotNull String getText();

    @Override
    public final void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        this.applyFix();
    }

    public void applyFix() {
        PsiElement endElement;
        if (this.myStartElement == null) {
            return;
        }
        PsiElement startElement = this.myStartElement.getElement();
        PsiElement psiElement = endElement = this.myEndElement == null ? startElement : this.myEndElement.getElement();
        if (startElement == null || endElement == null) {
            return;
        }
        PsiFile file = startElement.getContainingFile();
        if (file == null) {
            return;
        }
        this.invoke(file.getProject(), file, startElement, endElement);
    }

    public abstract void invoke(@NotNull Project var1, @NotNull PsiFile var2, @NotNull PsiElement var3, @NotNull PsiElement var4);

    @Override
    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        LocalQuickFixOnPsiElement clone;
        if (LocalQuickFix.super.getFileModifierForPreview(target) != this) {
            return null;
        }
        PsiElement startElement = this.getStartElement();
        PsiElement endElement = this.getEndElement();
        if (startElement == null && this.myStartElement != null || endElement == null && this.myEndElement != null) {
            return null;
        }
        startElement = PsiTreeUtil.findSameElementInCopy(startElement, target);
        endElement = PsiTreeUtil.findSameElementInCopy(endElement, target);
        try {
            clone = (LocalQuickFixOnPsiElement)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
        if (startElement != null) {
            ReflectionUtil.setField(LocalQuickFixOnPsiElement.class, (Object)clone, SmartPsiElementPointer.class, (String)"myStartElement", SmartPointerManager.createPointer(startElement));
        }
        if (endElement != null) {
            ReflectionUtil.setField(LocalQuickFixOnPsiElement.class, (Object)clone, SmartPsiElementPointer.class, (String)"myEndElement", SmartPointerManager.createPointer(endElement));
        }
        return clone;
    }

    @Override
    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        if (!this.startInWriteAction()) {
            return null;
        }
        if (this.myStartElement != null) {
            return this.myStartElement.getContainingFile();
        }
        return currentFile;
    }

    @Deprecated
    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
}

