/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.BatchSuppressableTool;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InjectionAwareSuppressQuickFix;
import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LanguageInspectionSuppressors;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.ex.InspectionElementsMerger;
import com.intellij.configurationStore.XmlSerializer;
import com.intellij.diagnostic.PluginException;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.serialization.SerializationException;
import com.intellij.util.ResourceUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.annotations.Property;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Property(assertIfNoBindings=false)
public abstract class InspectionProfileEntry
implements BatchSuppressableTool {
    private static final Logger LOG = Logger.getInstance(InspectionProfileEntry.class);
    private static Set<String> ourBlackList;
    private static final Object BLACK_LIST_LOCK;
    private Boolean myUseNewSerializer;
    protected volatile DefaultNameProvider myNameProvider;

    @NonNls
    @Nullable
    public String getAlternativeID() {
        return null;
    }

    @Override
    public boolean isSuppressedFor(@NotNull PsiElement element) {
        Set<InspectionSuppressor> suppressors = InspectionProfileEntry.getSuppressors(element);
        return !suppressors.isEmpty() && this.isSuppressedFor(element, suppressors);
    }

    private boolean isSuppressedFor(@NotNull PsiElement element, Set<InspectionSuppressor> suppressors) {
        String toolId = this.getSuppressId();
        for (InspectionSuppressor suppressor : suppressors) {
            if (!this.isSuppressed(toolId, suppressor, element)) continue;
            return true;
        }
        InspectionElementsMerger merger = InspectionElementsMerger.getMerger(this.getShortName());
        return merger != null && InspectionProfileEntry.isSuppressedForMerger(element, suppressors, merger);
    }

    private static boolean isSuppressedForMerger(PsiElement element, Set<InspectionSuppressor> suppressors, InspectionElementsMerger merger) {
        String[] sourceToolIds;
        String[] suppressIds = merger.getSuppressIds();
        for (String sourceToolId : sourceToolIds = suppressIds.length != 0 ? suppressIds : merger.getSourceToolNames()) {
            for (InspectionSuppressor suppressor : suppressors) {
                if (!suppressor.isSuppressedFor(element, sourceToolId)) continue;
                return true;
            }
        }
        return false;
    }

    @NonNls
    @NotNull
    protected String getSuppressId() {
        return this.getShortName();
    }

    @Override
    public SuppressQuickFix @NotNull [] getBatchSuppressActions(@Nullable PsiElement element) {
        if (element == null) {
            return SuppressQuickFix.EMPTY_ARRAY;
        }
        THashSet fixes = new THashSet((TObjectHashingStrategy)new TObjectHashingStrategy<SuppressQuickFix>(){

            public int computeHashCode(SuppressQuickFix object) {
                int result = object instanceof InjectionAwareSuppressQuickFix ? ((InjectionAwareSuppressQuickFix)object).isShouldBeAppliedToInjectionHost().hashCode() : 0;
                return 31 * result + object.getName().hashCode();
            }

            public boolean equals(SuppressQuickFix o1, SuppressQuickFix o2) {
                if (o1 instanceof InjectionAwareSuppressQuickFix && o2 instanceof InjectionAwareSuppressQuickFix && ((InjectionAwareSuppressQuickFix)o1).isShouldBeAppliedToInjectionHost() != ((InjectionAwareSuppressQuickFix)o2).isShouldBeAppliedToInjectionHost()) {
                    return false;
                }
                return o1.getName().equals(o2.getName());
            }
        });
        Set<InspectionSuppressor> suppressors = InspectionProfileEntry.getSuppressors(element);
        PsiLanguageInjectionHost injectionHost = InjectedLanguageManager.getInstance(element.getProject()).getInjectionHost(element);
        if (injectionHost != null) {
            Set<InspectionSuppressor> injectionHostSuppressors = InspectionProfileEntry.getSuppressors(injectionHost);
            for (InspectionSuppressor suppressor : injectionHostSuppressors) {
                InspectionProfileEntry.addAllSuppressActions((Collection<? super SuppressQuickFix>)fixes, injectionHost, suppressor, ThreeState.YES, this.getSuppressId());
            }
        }
        for (InspectionSuppressor suppressor : suppressors) {
            InspectionProfileEntry.addAllSuppressActions((Collection<? super SuppressQuickFix>)fixes, element, suppressor, injectionHost != null ? ThreeState.NO : ThreeState.UNSURE, this.getSuppressId());
        }
        return fixes.toArray(SuppressQuickFix.EMPTY_ARRAY);
    }

    private static void addAllSuppressActions(@NotNull Collection<? super SuppressQuickFix> fixes, @NotNull PsiElement element, @NotNull InspectionSuppressor suppressor, @NotNull ThreeState appliedToInjectionHost, @NotNull String toolId) {
        SuppressQuickFix[] actions;
        for (SuppressQuickFix action : actions = suppressor.getSuppressActions(element, toolId)) {
            if (action instanceof InjectionAwareSuppressQuickFix) {
                ((InjectionAwareSuppressQuickFix)action).setShouldBeAppliedToInjectionHost(appliedToInjectionHost);
            }
            fixes.add(action);
        }
    }

    private boolean isSuppressed(@NotNull String toolId, @NotNull InspectionSuppressor suppressor, @NotNull PsiElement element) {
        if (suppressor.isSuppressedFor(element, toolId)) {
            return true;
        }
        String alternativeId = this.getAlternativeID();
        return alternativeId != null && !alternativeId.equals(toolId) && suppressor.isSuppressedFor(element, alternativeId);
    }

    @NotNull
    public static Set<InspectionSuppressor> getSuppressors(@NotNull PsiElement element) {
        PsiUtilCore.ensureValid(element);
        FileViewProvider viewProvider = element.getContainingFile().getViewProvider();
        List elementLanguageSuppressor = LanguageInspectionSuppressors.INSTANCE.allForLanguage(element.getLanguage());
        if (viewProvider instanceof TemplateLanguageFileViewProvider) {
            LinkedHashSet<InspectionSuppressor> suppressors = new LinkedHashSet<InspectionSuppressor>();
            ContainerUtil.addAllNotNull(suppressors, LanguageInspectionSuppressors.INSTANCE.allForLanguage(viewProvider.getBaseLanguage()));
            for (Language language : viewProvider.getLanguages()) {
                ContainerUtil.addAllNotNull(suppressors, LanguageInspectionSuppressors.INSTANCE.allForLanguage(language));
            }
            ContainerUtil.addAllNotNull(suppressors, elementLanguageSuppressor);
            return suppressors;
        }
        if (!element.getLanguage().isKindOf(viewProvider.getBaseLanguage())) {
            LinkedHashSet<InspectionSuppressor> suppressors = new LinkedHashSet<InspectionSuppressor>();
            ContainerUtil.addAllNotNull(suppressors, LanguageInspectionSuppressors.INSTANCE.allForLanguage(viewProvider.getBaseLanguage()));
            ContainerUtil.addAllNotNull(suppressors, elementLanguageSuppressor);
            return suppressors;
        }
        int size = elementLanguageSuppressor.size();
        switch (size) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(elementLanguageSuppressor.get(0));
            }
        }
        return new HashSet<InspectionSuppressor>(elementLanguageSuppressor);
    }

    public void cleanup(@NotNull Project project) {
    }

    public void initialize(@NotNull GlobalInspectionContext context) {
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getGroupDisplayName() {
        String name;
        if (this.myNameProvider != null && (name = this.myNameProvider.getDefaultGroupDisplayName()) != null) {
            return name;
        }
        PluginException.logPluginError(LOG, this.getClass() + ": group display name should be overridden or configured via XML ", null, this.getClass());
        return "";
    }

    @NonNls
    @Nullable
    public String getGroupKey() {
        if (this.myNameProvider != null) {
            return this.myNameProvider.getGroupKey();
        }
        return null;
    }

    public @Nls(capitalization=Nls.Capitalization.Sentence) String @NotNull [] getGroupPath() {
        String groupDisplayName = this.getGroupDisplayName();
        if (groupDisplayName.isEmpty()) {
            groupDisplayName = InspectionProfileEntry.getGeneralGroupName();
        }
        return new String[]{groupDisplayName};
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getDisplayName() {
        String name;
        if (this.myNameProvider != null && (name = this.myNameProvider.getDefaultDisplayName()) != null) {
            return name;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            PluginException.logPluginError(LOG, this.getClass() + ": display name should be overridden or configured via XML ", null, this.getClass());
        }
        return "";
    }

    @NonNls
    @NotNull
    public String getShortName() {
        String name;
        if (this.myNameProvider != null && (name = this.myNameProvider.getDefaultShortName()) != null) {
            return name;
        }
        return InspectionProfileEntry.getShortName(this.getClass().getSimpleName());
    }

    @NotNull
    public static String getShortName(@NotNull String className) {
        return StringUtil.trimEnd((String)StringUtil.trimEnd((String)className, (String)"Inspection"), (String)"InspectionBase");
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        return HighlightDisplayLevel.WARNING;
    }

    public boolean isEnabledByDefault() {
        return false;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return null;
    }

    public boolean showDefaultConfigurationOptions() {
        return true;
    }

    public void readSettings(@NotNull Element node) {
        if (this.useNewSerializer()) {
            try {
                XmlSerializer.deserializeInto(node, this);
            }
            catch (SerializationException e) {
                throw new InvalidDataException((Throwable)e);
            }
        } else {
            DefaultJDOMExternalizer.readExternal((Object)this, (Element)node);
        }
    }

    public void writeSettings(@NotNull Element node) {
        if (this.useNewSerializer()) {
            XmlSerializer.serializeObjectInto(this, node, this.getSerializationFilter());
        } else {
            DefaultJDOMExternalizer.writeExternal((Object)this, (Element)node);
        }
    }

    private synchronized boolean useNewSerializer() {
        if (this.myUseNewSerializer == null) {
            this.myUseNewSerializer = !InspectionProfileEntry.getBlackList().contains(this.getClass().getName());
        }
        return this.myUseNewSerializer;
    }

    private static void loadBlackList() {
        ourBlackList = new HashSet<String>();
        URL url = InspectionProfileEntry.class.getResource("inspection-black-list.txt");
        if (url == null) {
            LOG.error("Resource not found");
            return;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                ourBlackList.add(line);
            }
        }
        catch (IOException e) {
            LOG.error("Unable to load resource: " + url, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Collection<String> getBlackList() {
        Object object = BLACK_LIST_LOCK;
        synchronized (object) {
            if (ourBlackList == null) {
                InspectionProfileEntry.loadBlackList();
            }
            return ourBlackList;
        }
    }

    @Deprecated
    @Nullable
    protected SerializationFilter getSerializationFilter() {
        return XmlSerializer.getJdomSerializer().getDefaultSerializationFilter();
    }

    @Nullable
    public String getStaticDescription() {
        return null;
    }

    @Nullable
    public String getDescriptionFileName() {
        return null;
    }

    @NotNull
    protected Class<? extends InspectionProfileEntry> getDescriptionContextClass() {
        return this.getClass();
    }

    public boolean isInitialized() {
        return true;
    }

    @NonNls
    @Nullable
    public String getMainToolId() {
        return null;
    }

    @Nullable
    public String loadDescription() {
        String description = this.getStaticDescription();
        if (description != null) {
            return description;
        }
        try {
            InputStream descriptionStream = null;
            String fileName = this.getDescriptionFileName();
            if (fileName != null) {
                descriptionStream = ResourceUtil.getResourceAsStream(this.getDescriptionContextClass(), (String)"/inspectionDescriptions", (String)fileName);
            }
            return descriptionStream != null ? ResourceUtil.loadText(descriptionStream) : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String getGeneralGroupName() {
        return InspectionsBundle.message("inspection.general.tools.group.name", new Object[0]);
    }

    static {
        BLACK_LIST_LOCK = new Object();
    }

    static interface DefaultNameProvider {
        @NonNls
        @Nullable
        public String getDefaultShortName();

        @NonNls
        @Nullable
        public String getGroupKey();

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @Nullable
        public String getDefaultDisplayName();

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @Nullable
        public String getDefaultGroupDisplayName();
    }
}

