/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionProcess;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompletionParameters {
    private final PsiElement myPosition;
    private final PsiFile myOriginalFile;
    private final CompletionType myCompletionType;
    @NotNull
    private final Editor myEditor;
    private final int myOffset;
    private final int myInvocationCount;
    private final CompletionProcess myProcess;
    private boolean isTestingMode = false;
    private boolean completeOnlyNotImported = false;

    @ApiStatus.Internal
    public CompletionParameters(@NotNull PsiElement position, @NotNull PsiFile originalFile, @NotNull CompletionType completionType, int offset, int invocationCount, @NotNull Editor editor, @NotNull CompletionProcess process) {
        PsiUtilCore.ensureValid(position);
        assert (position.getTextRange().containsOffset(offset)) : position;
        this.myPosition = position;
        this.myOriginalFile = originalFile;
        this.myCompletionType = completionType;
        this.myOffset = offset;
        this.myInvocationCount = invocationCount;
        this.myEditor = editor;
        this.myProcess = process;
    }

    @NotNull
    public CompletionParameters withType(@NotNull CompletionType type) {
        return new CompletionParameters(this.myPosition, this.myOriginalFile, type, this.myOffset, this.myInvocationCount, this.myEditor, this.myProcess);
    }

    @NotNull
    public CompletionParameters withInvocationCount(int newCount) {
        return new CompletionParameters(this.myPosition, this.myOriginalFile, this.myCompletionType, this.myOffset, newCount, this.myEditor, this.myProcess);
    }

    @NotNull
    public PsiElement getPosition() {
        return this.myPosition;
    }

    @Nullable
    public PsiElement getOriginalPosition() {
        return this.myOriginalFile.findElementAt(this.myPosition.getTextRange().getStartOffset());
    }

    @NotNull
    public PsiFile getOriginalFile() {
        return this.myOriginalFile;
    }

    @NotNull
    public CompletionType getCompletionType() {
        return this.myCompletionType;
    }

    public int getOffset() {
        return this.myOffset;
    }

    public int getInvocationCount() {
        return this.myInvocationCount;
    }

    public boolean isAutoPopup() {
        return this.myInvocationCount == 0;
    }

    @NotNull
    public CompletionParameters withPosition(@NotNull PsiElement element, int offset) {
        return new CompletionParameters(element, this.myOriginalFile, this.myCompletionType, offset, this.myInvocationCount, this.myEditor, this.myProcess);
    }

    public boolean isExtendedCompletion() {
        return this.myCompletionType == CompletionType.BASIC && this.myInvocationCount >= 2;
    }

    @NotNull
    public Editor getEditor() {
        return this.myEditor;
    }

    @NotNull
    public CompletionProcess getProcess() {
        return this.myProcess;
    }

    public boolean isTestingMode() {
        return this.isTestingMode;
    }

    public void setIsTestingMode(boolean runTestingMode) {
        this.isTestingMode = runTestingMode;
    }

    public boolean isCompleteOnlyNotImported() {
        return this.completeOnlyNotImported;
    }

    public void setCompleteOnlyNotImported(boolean onlyNonImported) {
        this.completeOnlyNotImported = onlyNonImported;
    }
}

