/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.properties;

import com.intellij.application.options.codeStyle.properties.BooleanAccessor;
import com.intellij.application.options.codeStyle.properties.BraceStyleAccessor;
import com.intellij.application.options.codeStyle.properties.CodeStyleFieldAccessor;
import com.intellij.application.options.codeStyle.properties.CommaSeparatedValues;
import com.intellij.application.options.codeStyle.properties.CommaSeparatedValuesAccessor;
import com.intellij.application.options.codeStyle.properties.EnumPropertyAccessor;
import com.intellij.application.options.codeStyle.properties.ForceBracesAccessor;
import com.intellij.application.options.codeStyle.properties.IntegerAccessor;
import com.intellij.application.options.codeStyle.properties.StringAccessor;
import com.intellij.application.options.codeStyle.properties.WrapOnTypingAccessor;
import com.intellij.application.options.codeStyle.properties.WrappingAccessor;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FieldAccessorFactory {
    private final Field myField;

    FieldAccessorFactory(Field field) {
        this.myField = field;
    }

    private ValueType getValueType() {
        String fieldName = this.myField.getName();
        Class<?> fieldType = this.myField.getType();
        String name = fieldType.getName();
        if (fieldType.isPrimitive()) {
            if ("int".equals(name)) {
                CommonCodeStyleSettings.WrapConstant wrapAnnotation = this.myField.getAnnotation(CommonCodeStyleSettings.WrapConstant.class);
                if (wrapAnnotation != null) {
                    return ValueType.WRAP;
                }
                CommonCodeStyleSettings.BraceStyleConstant braceAnnotation = this.myField.getAnnotation(CommonCodeStyleSettings.BraceStyleConstant.class);
                if (braceAnnotation != null) {
                    return ValueType.BRACE_STYLE;
                }
                if (fieldName.endsWith("_BRACE_FORCE")) {
                    return ValueType.FORCE_BRACES;
                }
                return ValueType.INT;
            }
            if ("boolean".equals(name)) {
                return ValueType.BOOLEAN;
            }
        } else {
            if ("java.lang.String".equals(name)) {
                return ValueType.STRING;
            }
            if (fieldType.isEnum()) {
                return ValueType.ENUM;
            }
        }
        return ValueType.OTHER;
    }

    @Nullable
    CodeStyleFieldAccessor<?, ?> createAccessor(@NotNull Object codeStyleObject) {
        if (this.mayHaveAccessor()) {
            switch (this.getValueType()) {
                case BOOLEAN: {
                    if ("USE_TAB_CHARACTER".equals(this.myField.getName())) {
                        return new TabCharPropertyAccessor(codeStyleObject, this.myField);
                    }
                    return new BooleanAccessor(codeStyleObject, this.myField);
                }
                case INT: {
                    if ("WRAP_ON_TYPING".equals(this.myField.getName())) {
                        return new WrapOnTypingAccessor(codeStyleObject, this.myField);
                    }
                    return new IntegerAccessor(codeStyleObject, this.myField);
                }
                case STRING: {
                    CommaSeparatedValues annotation = this.myField.getAnnotation(CommaSeparatedValues.class);
                    if (annotation != null) {
                        return new CommaSeparatedValuesAccessor(codeStyleObject, this.myField);
                    }
                    return new StringAccessor(codeStyleObject, this.myField);
                }
                case WRAP: {
                    return new WrappingAccessor(codeStyleObject, this.myField);
                }
                case BRACE_STYLE: {
                    return new BraceStyleAccessor(codeStyleObject, this.myField);
                }
                case FORCE_BRACES: {
                    return new ForceBracesAccessor(codeStyleObject, this.myField);
                }
                case ENUM: {
                    return new EnumPropertyAccessor(codeStyleObject, this.myField);
                }
            }
        }
        return null;
    }

    private boolean mayHaveAccessor() {
        int modifiers = this.myField.getModifiers();
        return !Modifier.isStatic(modifiers) && !Modifier.isFinal(modifiers) && this.myField.getType().getCanonicalName() != null && this.myField.getAnnotation(Deprecated.class) == null;
    }

    private static class TabCharPropertyAccessor
    extends CodeStyleFieldAccessor<Boolean, String> {
        TabCharPropertyAccessor(@NotNull Object object, @NotNull Field field) {
            super(object, field);
        }

        @Override
        @Nullable
        protected String parseString(@NotNull String string) {
            return string;
        }

        @Override
        @Nullable
        protected String valueToString(@NotNull String value) {
            return value;
        }

        @Override
        @Nullable
        protected Boolean fromExternal(@NotNull String str) {
            return "tab".equalsIgnoreCase(str);
        }

        @Override
        @NotNull
        protected String toExternal(@NotNull Boolean value) {
            return value != false ? "tab" : "space";
        }

        @Override
        public String getPropertyName() {
            return "indent_style";
        }
    }

    private static enum ValueType {
        BOOLEAN,
        INT,
        STRING,
        WRAP,
        BRACE_STYLE,
        FORCE_BRACES,
        ENUM,
        OTHER;

    }
}

