/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.ContinuationOption;
import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmartIndentOptionsEditor
extends IndentOptionsEditor {
    private JCheckBox myCbSmartTabs;
    private final ContinuationOption myContinuationOption;
    private final ContinuationOption myDeclarationParameterIndentOption;
    private final ContinuationOption myGenericTypeParameterIndentOption;
    private final ContinuationOption myCallParameterIndentOption;
    private final ContinuationOption myChainedCallIndentOption;
    private final ContinuationOption myArrayElementIndentOption;
    private final List<ContinuationOption> myContinuationOptions = new ArrayList<ContinuationOption>();
    private JCheckBox myCbKeepIndentsOnEmptyLines;

    public SmartIndentOptionsEditor() {
        this((LanguageCodeStyleSettingsProvider)null);
    }

    public SmartIndentOptionsEditor(@Nullable LanguageCodeStyleSettingsProvider provider) {
        super(provider);
        this.myContinuationOption = this.createContinuationOption(SmartIndentOptionsEditor.getContinuationIndentLabel(), options -> options.CONTINUATION_INDENT_SIZE, (options, value) -> {
            options.CONTINUATION_INDENT_SIZE = value;
        }, 8);
        this.myContinuationOption.setSupported(true);
        this.myDeclarationParameterIndentOption = this.createContinuationOption("Declaration parameter indent:", options -> options.DECLARATION_PARAMETER_INDENT, (options, value) -> {
            options.DECLARATION_PARAMETER_INDENT = value;
        }, -1);
        this.myGenericTypeParameterIndentOption = this.createContinuationOption("Generic type parameter indent:", options -> options.GENERIC_TYPE_PARAMETER_INDENT, (options, value) -> {
            options.GENERIC_TYPE_PARAMETER_INDENT = value;
        }, -1);
        this.myCallParameterIndentOption = this.createContinuationOption("Call parameter indent:", options -> options.CALL_PARAMETER_INDENT, (options, value) -> {
            options.CALL_PARAMETER_INDENT = value;
        }, -1);
        this.myChainedCallIndentOption = this.createContinuationOption("Chained call indent:", options -> options.CHAINED_CALL_INDENT, (options, value) -> {
            options.CHAINED_CALL_INDENT = value;
        }, -1);
        this.myArrayElementIndentOption = this.createContinuationOption("Array element indent:", options -> options.ARRAY_ELEMENT_INDENT, (options, value) -> {
            options.ARRAY_ELEMENT_INDENT = value;
        }, -1);
    }

    private ContinuationOption createContinuationOption(@NotNull String labelText, Function<? super CommonCodeStyleSettings.IndentOptions, Integer> getter, BiConsumer<? super CommonCodeStyleSettings.IndentOptions, ? super Integer> setter, int defaultValue) {
        ContinuationOption option = new ContinuationOption(labelText, getter, setter, defaultValue);
        this.myContinuationOptions.add(option);
        return option;
    }

    @Override
    protected void addTabOptions() {
        super.addTabOptions();
        this.myCbSmartTabs = new JCheckBox(ApplicationBundle.message("checkbox.indent.smart.tabs", new Object[0]));
        this.add((JComponent)this.myCbSmartTabs, true);
    }

    @Override
    protected void addComponents() {
        super.addComponents();
        for (ContinuationOption option : this.myContinuationOptions) {
            option.addToEditor(this);
        }
        this.myContinuationOption.addListener(newValue -> this.updateDefaults((Integer)newValue));
        this.myCbKeepIndentsOnEmptyLines = new JCheckBox(ApplicationBundle.message("checkbox.indent.keep.indents.on.empty.lines", new Object[0]));
        this.add(this.myCbKeepIndentsOnEmptyLines);
    }

    private void updateDefaults(@NotNull Integer value) {
        for (ContinuationOption option : this.myContinuationOptions) {
            if (option == this.myContinuationOption) continue;
            option.setDefaultValueToDisplay(value);
        }
    }

    @Override
    public boolean isModified(CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions options) {
        boolean isModified = super.isModified(settings, options);
        isModified |= SmartIndentOptionsEditor.isFieldModified(this.myCbSmartTabs, options.SMART_TABS);
        for (ContinuationOption continuationOption : this.myContinuationOptions) {
            isModified |= continuationOption.isModified(options);
        }
        return isModified |= SmartIndentOptionsEditor.isFieldModified(this.myCbKeepIndentsOnEmptyLines, options.KEEP_INDENTS_ON_EMPTY_LINES);
    }

    @Override
    public void apply(CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions options) {
        super.apply(settings, options);
        for (ContinuationOption continuationOption : this.myContinuationOptions) {
            continuationOption.apply(options);
        }
        options.SMART_TABS = SmartIndentOptionsEditor.isSmartTabValid(options.INDENT_SIZE, options.TAB_SIZE) && this.myCbSmartTabs.isSelected();
        options.KEEP_INDENTS_ON_EMPTY_LINES = this.myCbKeepIndentsOnEmptyLines.isSelected();
    }

    @Override
    public void reset(@NotNull CodeStyleSettings settings, @NotNull CommonCodeStyleSettings.IndentOptions options) {
        super.reset(settings, options);
        for (ContinuationOption continuationOption : this.myContinuationOptions) {
            continuationOption.reset(options);
        }
        this.myCbSmartTabs.setSelected(options.SMART_TABS);
        this.myCbKeepIndentsOnEmptyLines.setSelected(options.KEEP_INDENTS_ON_EMPTY_LINES);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        boolean smartTabsChecked = enabled && this.myCbUseTab.isSelected();
        boolean smartTabsValid = smartTabsChecked && SmartIndentOptionsEditor.isSmartTabValid(this.getUIIndent(), this.getUITabSize());
        this.myCbSmartTabs.setEnabled(smartTabsValid);
        this.myCbSmartTabs.setToolTipText(smartTabsChecked && !smartTabsValid ? ApplicationBundle.message("tooltip.indent.must.be.multiple.of.tab.size.for.smart.tabs.to.operate", new Object[0]) : null);
        this.myContinuationOption.setEnabled(enabled);
        this.myCbKeepIndentsOnEmptyLines.setEnabled(enabled);
    }

    private static boolean isSmartTabValid(int indent, int tabSize) {
        return indent / tabSize * tabSize == indent;
    }

    public SmartIndentOptionsEditor withDeclarationParameterIndent() {
        this.myDeclarationParameterIndentOption.setSupported(true);
        return this;
    }

    public SmartIndentOptionsEditor withGenericTypeParameterIndent() {
        this.myGenericTypeParameterIndentOption.setSupported(true);
        return this;
    }

    public SmartIndentOptionsEditor withCallParameterIndent() {
        this.myCallParameterIndentOption.setSupported(true);
        return this;
    }

    public SmartIndentOptionsEditor withChainedCallIndent() {
        this.myChainedCallIndentOption.setSupported(true);
        return this;
    }

    public SmartIndentOptionsEditor withArrayElementIndent() {
        this.myArrayElementIndentOption.setSupported(true);
        return this;
    }

    @Override
    public void showStandardOptions(String ... optionNames) {
        super.showStandardOptions(optionNames);
        for (String optionName : optionNames) {
            if (CodeStyleSettingsCustomizable.IndentOption.SMART_TABS.toString().equals(optionName)) {
                this.myCbSmartTabs.setVisible(true);
                continue;
            }
            if (CodeStyleSettingsCustomizable.IndentOption.CONTINUATION_INDENT_SIZE.toString().equals(optionName)) {
                this.myContinuationOption.setVisible(true);
                continue;
            }
            if (!CodeStyleSettingsCustomizable.IndentOption.KEEP_INDENTS_ON_EMPTY_LINES.toString().equals(optionName)) continue;
            this.myCbKeepIndentsOnEmptyLines.setVisible(true);
        }
    }

    @Override
    protected void setVisible(boolean visible) {
        super.setVisible(visible);
        this.myCbSmartTabs.setVisible(visible);
        this.myContinuationOption.setVisible(visible);
        this.myCbKeepIndentsOnEmptyLines.setVisible(visible);
    }

    public static String getContinuationIndentLabel() {
        return ApplicationBundle.message("editbox.indent.continuation.indent", new Object[0]);
    }
}

