/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
@ApiStatus.Experimental
public interface FileIntPropertyPusher<T>
extends FilePropertyPusher<T> {
    @NotNull
    public FileAttribute getAttribute();

    public int toInt(@NotNull T var1) throws IOException;

    @NotNull
    public T fromInt(int var1) throws IOException;

    @Override
    default public void persistAttribute(@NotNull Project project, @NotNull VirtualFile fileOrDir, @NotNull T actualValue) throws IOException {
        try (Closeable stream = this.getAttribute().readAttribute(fileOrDir);){
            if (stream != null) {
                int storedIntValue = DataInputOutputUtil.readINT((DataInput)((Object)stream));
                if (storedIntValue == this.toInt(actualValue)) {
                    return;
                }
            }
        }
        stream = this.getAttribute().writeAttribute(fileOrDir);
        var5_5 = null;
        try {
            DataInputOutputUtil.writeINT((DataOutput)((Object)stream), (int)this.toInt(actualValue));
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (stream != null) {
                if (var5_5 != null) {
                    try {
                        ((FilterOutputStream)stream).close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    ((FilterOutputStream)stream).close();
                }
            }
        }
        this.propertyChanged(project, fileOrDir, actualValue);
    }

    public void propertyChanged(@NotNull Project var1, @NotNull VirtualFile var2, @NotNull T var3);
}

