/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.AbstractBundle;
import com.intellij.BundleBase;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AbstractExtensionPointBean;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Map;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DynamicBundle
extends AbstractBundle {
    private static final Logger LOG = Logger.getInstance(DynamicBundle.class);
    private static final Method SET_PARENT = ReflectionUtil.getDeclaredMethod(ResourceBundle.class, (String)"setParent", (Class[])new Class[]{ResourceBundle.class});
    public static final DynamicBundle INSTANCE = new DynamicBundle(""){};
    private static final Map<String, DynamicBundle> ourBundlesForForms = ContainerUtil.createConcurrentSoftValueMap();

    protected DynamicBundle(@NotNull String pathToBundle) {
        super(pathToBundle);
    }

    protected ResourceBundle findBundle(@NotNull String pathToBundle, @NotNull ClassLoader baseLoader, @NotNull ResourceBundle.Control control) {
        ResourceBundle base = super.findBundle(pathToBundle, baseLoader, control);
        LanguageBundleEP langBundle = DynamicBundle.findLanguageBundle();
        if (langBundle == null) {
            return base;
        }
        ResourceBundle pluginBundle = super.findBundle(pathToBundle, langBundle.getLoaderForClass(), control);
        if (pluginBundle == null) {
            return base;
        }
        try {
            if (SET_PARENT != null) {
                SET_PARENT.invoke((Object)pluginBundle, base);
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            return base;
        }
        return pluginBundle;
    }

    @Nullable
    private static LanguageBundleEP findLanguageBundle() {
        try {
            Application application = ApplicationManager.getApplication();
            if (application == null) {
                return null;
            }
            if (application.isUnitTestMode() && !application.getExtensionArea().hasExtensionPoint(LanguageBundleEP.EP_NAME)) {
                return null;
            }
            return (LanguageBundleEP)((Object)LanguageBundleEP.EP_NAME.findExtension(LanguageBundleEP.class));
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @Deprecated
    public static ResourceBundle getBundle(@NotNull String baseName) {
        Class callerClass = ReflectionUtil.findCallerClass((int)2);
        return DynamicBundle.getBundle(baseName, callerClass == null ? DynamicBundle.class : callerClass);
    }

    @Deprecated
    public static ResourceBundle getBundle(@NotNull String baseName, @NotNull Class<?> formClass) {
        DynamicBundle dynamic = ourBundlesForForms.computeIfAbsent(baseName, s -> new DynamicBundle((String)s){});
        final ResourceBundle rb = dynamic.getResourceBundle(formClass.getClassLoader());
        if (BundleBase.SHOW_LOCALIZED_MESSAGES) {
            return new ResourceBundle(){

                @Override
                protected Object handleGetObject(@NotNull String key) {
                    Object get = rb.getObject(key);
                    assert (get instanceof String) : "Language bundles should contain only strings";
                    return BundleBase.appendLocalizationMarker((String)((String)get));
                }

                @Override
                @NotNull
                public Enumeration<String> getKeys() {
                    return rb.getKeys();
                }
            };
        }
        return rb;
    }

    public static class LanguageBundleEP
    extends AbstractExtensionPointBean {
        public static final ExtensionPointName<LanguageBundleEP> EP_NAME = ExtensionPointName.create((String)"com.intellij.languageBundle");
    }
}

