/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.patterns.DomElementPattern;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.StandardPatterns;
import com.intellij.util.ProcessingContext;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericDomValuePattern<T>
extends DomElementPattern<GenericDomValue<T>, GenericDomValuePattern<T>> {
    private static final InitialPatternCondition CONDITION = new InitialPatternCondition(GenericDomValue.class){

        public boolean accepts(@Nullable Object o, ProcessingContext context) {
            return o instanceof GenericDomValue;
        }
    };

    protected GenericDomValuePattern() {
        super(CONDITION);
    }

    protected GenericDomValuePattern(final Class<T> aClass) {
        super(new InitialPatternCondition(aClass){

            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                return o instanceof GenericDomValue && aClass.equals(DomUtil.getGenericValueParameter(((GenericDomValue)o).getDomElementType()));
            }
        });
    }

    public GenericDomValuePattern<T> withStringValue(final ElementPattern<String> pattern) {
        return (GenericDomValuePattern)this.with(new PatternCondition<GenericDomValue<T>>("withStringValue"){

            public boolean accepts(@NotNull GenericDomValue<T> genericDomValue, ProcessingContext context) {
                return pattern.accepts((Object)genericDomValue.getStringValue(), context);
            }
        });
    }

    public GenericDomValuePattern<T> withValue(@NotNull T value) {
        return this.withValue((ElementPattern<?>)StandardPatterns.object(value));
    }

    public GenericDomValuePattern<T> withValue(final ElementPattern<?> pattern) {
        return (GenericDomValuePattern)this.with(new PatternCondition<GenericDomValue<T>>("withValue"){

            public boolean accepts(@NotNull GenericDomValue<T> genericDomValue, ProcessingContext context) {
                return pattern.accepts(genericDomValue.getValue(), context);
            }
        });
    }
}

