/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.AbstractBundle;
import com.intellij.DynamicBundle;
import com.intellij.ide.IconLayerProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IconDeferrer;
import com.intellij.ui.IconDescriptionBundleEP;
import com.intellij.ui.IconManager;
import com.intellij.ui.IconWithToolTip;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.OffsetIcon;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.BitUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.List;
import java.util.ResourceBundle;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public final class CoreIconManager
implements IconManager {
    private static final List<IconLayer> ourIconLayers = ContainerUtil.createLockFreeCopyOnWriteList();
    private static final int FLAGS_LOCKED = 2048;
    private static final Logger LOG = Logger.getInstance(CoreIconManager.class);

    @NotNull
    public Icon getIcon(@NotNull String path, @NotNull Class aClass) {
        Icon icon = IconLoader.getIcon((String)path, (Class)aClass);
        return IconWithToolTip.create(icon, new IconDescriptionLoader(path));
    }

    @NotNull
    public Icon createEmptyIcon(@NotNull Icon icon) {
        return EmptyIcon.create((Icon)icon);
    }

    @NotNull
    public <T> Icon createDeferredIcon(@NotNull Icon base, T param, @NotNull Function<? super T, ? extends Icon> f) {
        return IconDeferrer.getInstance().defer(base, param, t -> (Icon)f.apply(t));
    }

    @NotNull
    public Icon getAnalyzeIcon() {
        return IconUtil.getAnalyzeIcon();
    }

    public void registerIconLayer(int flagMask, @NotNull Icon icon) {
        for (IconLayer iconLayer : ourIconLayers) {
            if (iconLayer.flagMask != flagMask) continue;
            return;
        }
        ourIconLayers.add(new IconLayer(flagMask, icon));
    }

    @NotNull
    public RowIcon createRowIcon(int iconCount, RowIcon.Alignment alignment) {
        return new com.intellij.ui.RowIcon(iconCount, alignment);
    }

    @NotNull
    public RowIcon createRowIcon(Icon ... icons) {
        return new com.intellij.ui.RowIcon(icons);
    }

    @NotNull
    public com.intellij.ui.RowIcon createLayeredIcon(@NotNull Iconable instance, Icon icon, int flags) {
        SmartList layersFromProviders = new SmartList();
        for (Object provider : IconLayerProvider.EP_NAME.getExtensionList()) {
            Icon layerIcon = provider.getLayerIcon(instance, BitUtil.isSet((int)flags, (int)2048));
            if (layerIcon == null) continue;
            layersFromProviders.add(layerIcon);
        }
        if (flags != 0 || !layersFromProviders.isEmpty()) {
            SmartList iconLayers = new SmartList();
            for (IconLayer l : ourIconLayers) {
                if (!BitUtil.isSet((int)flags, (int)l.flagMask)) continue;
                iconLayers.add(l.icon);
            }
            iconLayers.addAll(layersFromProviders);
            LayeredIcon layeredIcon = new LayeredIcon(1 + iconLayers.size());
            layeredIcon.setIcon(icon, 0);
            for (int i = 0; i < iconLayers.size(); ++i) {
                Icon icon1 = (Icon)iconLayers.get(i);
                layeredIcon.setIcon(icon1, i + 1);
            }
            icon = layeredIcon;
        }
        com.intellij.ui.RowIcon baseIcon = new com.intellij.ui.RowIcon(2);
        baseIcon.setIcon(icon, 0);
        return baseIcon;
    }

    @NotNull
    public Icon createOffsetIcon(@NotNull Icon icon) {
        return new OffsetIcon(icon);
    }

    @NotNull
    public Icon colorize(Graphics2D g, @NotNull Icon source, @NotNull Color color) {
        return IconUtil.colorize(g, source, color);
    }

    @NotNull
    public Icon createLayered(Icon ... icons) {
        return new LayeredIcon(icons);
    }

    private static class IconDescriptionLoader
    implements Supplier<String> {
        private final String myPath;
        private String myResult;
        private boolean myCalculated;

        private IconDescriptionLoader(String path) {
            this.myPath = path;
        }

        @Override
        public String get() {
            if (!this.myCalculated) {
                this.myResult = this.findIconDescription();
                this.myCalculated = true;
            }
            return this.myResult;
        }

        private String findIconDescription() {
            String basePath = StringUtil.trimStart((String)StringUtil.trimEnd((String)this.myPath, (String)".svg"), (String)"/");
            String key = "icon." + basePath.replace('/', '.') + ".tooltip";
            Ref result = new Ref();
            IconDescriptionBundleEP.EP_NAME.processWithPluginDescriptor((ep, descriptor) -> {
                ResourceBundle bundle;
                String description;
                ClassLoader classLoader;
                ClassLoader classLoader2 = classLoader = descriptor == null ? null : descriptor.getPluginClassLoader();
                if (classLoader == null) {
                    classLoader = this.getClass().getClassLoader();
                }
                if ((description = AbstractBundle.messageOrNull((ResourceBundle)(bundle = DynamicBundle.INSTANCE.getResourceBundle(ep.resourceBundle, classLoader)), (String)key, (Object[])new Object[0])) != null) {
                    result.set((Object)description);
                }
            });
            if (result.get() == null && Registry.is((String)"ide.icon.tooltips.trace.missing")) {
                LOG.info("Icon tooltip requested but not found for " + this.myPath);
            }
            return (String)result.get();
        }
    }

    private static class IconLayer {
        private final int flagMask;
        @NotNull
        private final Icon icon;

        private IconLayer(int flagMask, @NotNull Icon icon) {
            BitUtil.assertOneBitMask((int)flagMask);
            this.flagMask = flagMask;
            this.icon = icon;
        }
    }
}

