/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.StatisticsStringUtil;
import com.intellij.internal.statistic.connect.StatServiceException;
import com.intellij.internal.statistic.connect.StatisticsResult;
import com.intellij.internal.statistic.connect.StatisticsService;
import com.intellij.internal.statistic.eventLog.DataCollectorDebugLogger;
import com.intellij.internal.statistic.eventLog.DeviceConfiguration;
import com.intellij.internal.statistic.eventLog.EventLogApplicationInfo;
import com.intellij.internal.statistic.eventLog.EventLogBuildType;
import com.intellij.internal.statistic.eventLog.EventLogConnectionSettings;
import com.intellij.internal.statistic.eventLog.EventLogFile;
import com.intellij.internal.statistic.eventLog.EventLogRecorderConfig;
import com.intellij.internal.statistic.eventLog.EventLogResultDecorator;
import com.intellij.internal.statistic.eventLog.EventLogSendListener;
import com.intellij.internal.statistic.eventLog.EventLogSettingsService;
import com.intellij.internal.statistic.eventLog.EventLogUploadSettingsService;
import com.intellij.internal.statistic.eventLog.LogEventRecord;
import com.intellij.internal.statistic.eventLog.LogEventRecordRequest;
import com.intellij.internal.statistic.eventLog.LogEventSerializer;
import com.intellij.internal.statistic.eventLog.filters.LogEventFilter;
import com.intellij.internal.statistic.service.request.StatsHttpRequests;
import com.intellij.internal.statistic.service.request.StatsHttpResponse;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.http.Consts;
import org.apache.http.entity.ContentType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class EventLogStatisticsService
implements StatisticsService {
    private static final ContentType APPLICATION_JSON = ContentType.create((String)"application/json", (Charset)Consts.UTF_8);
    private static final int MAX_FILES_TO_SEND = 5;
    private final DeviceConfiguration myDeviceConfiguration;
    private final EventLogSettingsService mySettingsService;
    private final EventLogRecorderConfig myRecorderConfiguration;
    private final EventLogSendListener mySendListener;

    public EventLogStatisticsService(@NotNull DeviceConfiguration device, @NotNull EventLogRecorderConfig config, @NotNull EventLogApplicationInfo application, @Nullable EventLogSendListener listener) {
        this.myDeviceConfiguration = device;
        this.myRecorderConfiguration = config;
        this.mySettingsService = new EventLogUploadSettingsService(config.getRecorderId(), application);
        this.mySendListener = listener;
    }

    public EventLogStatisticsService(@NotNull DeviceConfiguration device, @NotNull EventLogRecorderConfig config, @Nullable EventLogSendListener listener, @Nullable EventLogUploadSettingsService settingsService) {
        this.myDeviceConfiguration = device;
        this.myRecorderConfiguration = config;
        this.mySettingsService = settingsService;
        this.mySendListener = listener;
    }

    @Override
    public StatisticsResult send() {
        return EventLogStatisticsService.send(this.myDeviceConfiguration, this.myRecorderConfiguration, this.mySettingsService, new EventLogCounterResultDecorator(this.mySendListener));
    }

    public StatisticsResult send(@NotNull EventLogResultDecorator decorator) {
        return EventLogStatisticsService.send(this.myDeviceConfiguration, this.myRecorderConfiguration, this.mySettingsService, decorator);
    }

    public static StatisticsResult send(@NotNull DeviceConfiguration device, @NotNull EventLogRecorderConfig config, @NotNull EventLogSettingsService settings, @NotNull EventLogResultDecorator decorator) {
        EventLogApplicationInfo info = settings.getApplicationInfo();
        DataCollectorDebugLogger logger = info.getLogger();
        List<EventLogFile> logs = EventLogStatisticsService.getLogFiles(config, logger);
        if (!config.isSendEnabled()) {
            EventLogStatisticsService.cleanupEventLogFiles(logs, logger);
            return new StatisticsResult(StatisticsResult.ResultCode.NOTHING_TO_SEND, "Event Log collector is not enabled");
        }
        if (logs.isEmpty()) {
            return new StatisticsResult(StatisticsResult.ResultCode.NOTHING_TO_SEND, "No files to send");
        }
        if (!settings.isSettingsReachable()) {
            return new StatisticsResult(StatisticsResult.ResultCode.ERROR_IN_CONFIG, "ERROR: settings server is unreachable");
        }
        if (!settings.isSendEnabled()) {
            EventLogStatisticsService.cleanupEventLogFiles(logs, logger);
            return new StatisticsResult(StatisticsResult.ResultCode.NOT_PERMITTED_SERVER, "NOT_PERMITTED");
        }
        String serviceUrl = settings.getServiceUrl();
        if (serviceUrl == null) {
            return new StatisticsResult(StatisticsResult.ResultCode.ERROR_IN_CONFIG, "ERROR: unknown Statistics Service URL.");
        }
        boolean isInternal = info.isInternal();
        String productCode = info.getProductCode();
        EventLogBuildType defaultBuildType = EventLogStatisticsService.getDefaultBuildType(info);
        LogEventFilter baseFilter = settings.getBaseEventFilter();
        try {
            EventLogConnectionSettings connectionSettings = info.getConnectionSettings();
            decorator.onLogsLoaded(logs.size());
            ArrayList<File> toRemove = new ArrayList<File>(logs.size());
            int size = Math.min(5, logs.size());
            for (int i = 0; i < size; ++i) {
                EventLogFile logFile = logs.get(i);
                File file = logFile.getFile();
                EventLogBuildType type = logFile.getType(defaultBuildType);
                LogEventFilter filter = settings.getEventFilter(baseFilter, type);
                String deviceId = device.getDeviceId();
                LogEventRecordRequest recordRequest = LogEventRecordRequest.Companion.create(file, config.getRecorderId(), productCode, deviceId, filter, isInternal, logger);
                String error = EventLogStatisticsService.validate(recordRequest, file);
                if (StatisticsStringUtil.isNotEmpty((String)error) || recordRequest == null) {
                    if (logger.isTraceEnabled()) {
                        logger.trace(file.getName() + "-> " + error);
                    }
                    decorator.onFailed(recordRequest, null);
                    toRemove.add(file);
                    continue;
                }
                try {
                    StatsHttpRequests.post(serviceUrl, connectionSettings).withBody(LogEventSerializer.INSTANCE.toString(recordRequest), APPLICATION_JSON).succeed((r, code) -> {
                        toRemove.add(file);
                        decorator.onSucceed(recordRequest, EventLogStatisticsService.loadAndLogResponse(logger, r, file), file.getAbsolutePath());
                    }).fail((r, code) -> {
                        if (code == 400) {
                            toRemove.add(file);
                        }
                        decorator.onFailed(recordRequest, EventLogStatisticsService.loadAndLogResponse(logger, r, file));
                    }).send();
                    continue;
                }
                catch (Exception e) {
                    if (logger.isTraceEnabled()) {
                        logger.trace(file.getName() + " -> " + e.getMessage());
                    }
                    decorator.onFailed(null, null);
                }
            }
            EventLogStatisticsService.cleanupFiles(toRemove, logger);
            return decorator.onFinished();
        }
        catch (Exception e) {
            String message = e.getMessage();
            logger.info(message != null ? message : "", e);
            throw new StatServiceException("Error during data sending.", e);
        }
    }

    @NotNull
    private static EventLogBuildType getDefaultBuildType(EventLogApplicationInfo info) {
        return info.isEAP() ? EventLogBuildType.EAP : EventLogBuildType.RELEASE;
    }

    @NotNull
    private static String loadAndLogResponse(@NotNull DataCollectorDebugLogger logger, @NotNull StatsHttpResponse response, @NotNull File file) throws IOException {
        String content;
        String message = response.readAsString();
        String string = content = message != null ? message : Integer.toString(response.getStatusCode());
        if (logger.isTraceEnabled()) {
            logger.trace(file.getName() + " -> " + content);
        }
        return content;
    }

    @Nullable
    private static String validate(@Nullable LogEventRecordRequest request, @NotNull File file) {
        if (request == null) {
            return "File is empty or has invalid format: " + file.getName();
        }
        if (StatisticsStringUtil.isEmpty((String)request.getDevice())) {
            return "Cannot upload event log, device ID is empty";
        }
        if (StatisticsStringUtil.isEmpty((String)request.getProduct())) {
            return "Cannot upload event log, product code is empty";
        }
        if (StatisticsStringUtil.isEmpty((String)request.getRecorder())) {
            return "Cannot upload event log, recorder code is empty";
        }
        if (request.getRecords().isEmpty()) {
            return "Cannot upload event log, record list is empty";
        }
        for (LogEventRecord content : request.getRecords()) {
            if (!content.getEvents().isEmpty()) continue;
            return "Cannot upload event log, event list is empty";
        }
        return null;
    }

    @NotNull
    protected static List<EventLogFile> getLogFiles(@NotNull EventLogRecorderConfig provider, @NotNull DataCollectorDebugLogger logger) {
        try {
            return provider.getLogFilesProvider().getLogFiles();
        }
        catch (Exception e) {
            String message = e.getMessage();
            logger.info(message != null ? message : "", e);
            return Collections.emptyList();
        }
    }

    private static void cleanupEventLogFiles(@NotNull List<EventLogFile> toRemove, @NotNull DataCollectorDebugLogger logger) {
        ArrayList<File> filesToRemove = new ArrayList<File>();
        for (EventLogFile file : toRemove) {
            filesToRemove.add(file.getFile());
        }
        EventLogStatisticsService.cleanupFiles(filesToRemove, logger);
    }

    private static void cleanupFiles(@NotNull List<File> toRemove, @NotNull DataCollectorDebugLogger logger) {
        for (File file : toRemove) {
            if (!file.delete()) {
                logger.warn("Failed deleting event log: " + file.getName());
            }
            if (!logger.isTraceEnabled()) continue;
            logger.trace("Removed sent log: " + file.getName());
        }
    }

    private static class EventLogCounterResultDecorator
    implements EventLogResultDecorator {
        private final EventLogSendListener myListener;
        private int myLocalFiles = -1;
        private int myFailed = 0;
        private final List<String> mySuccessfullySentFiles = new ArrayList<String>();

        private EventLogCounterResultDecorator(@Nullable EventLogSendListener listener) {
            this.myListener = listener;
        }

        @Override
        public void onLogsLoaded(int localFiles) {
            this.myLocalFiles = localFiles;
        }

        @Override
        public void onSucceed(@NotNull LogEventRecordRequest request, @NotNull String content, @NotNull String logPath) {
            this.mySuccessfullySentFiles.add(logPath);
        }

        @Override
        public void onFailed(@Nullable LogEventRecordRequest request, @Nullable String content) {
            ++this.myFailed;
        }

        @Override
        @NotNull
        public StatisticsResult onFinished() {
            int succeed;
            int total;
            if (this.myListener != null) {
                this.myListener.onLogsSend(this.mySuccessfullySentFiles, this.myFailed, this.myLocalFiles);
            }
            if ((total = (succeed = this.mySuccessfullySentFiles.size()) + this.myFailed) == 0) {
                return new StatisticsResult(StatisticsResult.ResultCode.NOTHING_TO_SEND, "No files to upload.");
            }
            if (this.myFailed > 0) {
                return new StatisticsResult(StatisticsResult.ResultCode.SENT_WITH_ERRORS, "Uploaded " + succeed + " out of " + total + " files.");
            }
            return new StatisticsResult(StatisticsResult.ResultCode.SEND, "Uploaded " + succeed + " files.");
        }
    }
}

