/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.status;

import com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class HgChangesetStatus {
    private final String myName;
    private int numChanges;
    private String toolTip;

    public HgChangesetStatus(@NotNull @Nls String name) {
        this.myName = name;
    }

    public void setChanges(int count, ChangesetWriter formatter) {
        ApplicationManager.getApplication().invokeLater(() -> {
            this.numChanges = count;
            this.toolTip = count != 0 ? formatter.asString() : "";
        });
    }

    public String getStatusName() {
        return this.myName;
    }

    public int getNumChanges() {
        return this.numChanges;
    }

    public String getToolTip() {
        return this.toolTip;
    }

    public void dispose() {
    }

    public static interface ChangesetWriter {
        @Nls
        public String asString();
    }
}

