/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.push;

import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.dvcs.push.OutgoingCommitsProvider;
import com.intellij.dvcs.push.PushSettings;
import com.intellij.dvcs.push.PushSupport;
import com.intellij.dvcs.push.PushTargetPanel;
import com.intellij.dvcs.push.Pusher;
import com.intellij.dvcs.push.VcsPushOptionsPanel;
import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgProjectSettings;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.push.HgOutgoingCommitsProvider;
import org.zmlx.hg4idea.push.HgPushOptionsPanel;
import org.zmlx.hg4idea.push.HgPushSource;
import org.zmlx.hg4idea.push.HgPushTargetPanel;
import org.zmlx.hg4idea.push.HgPusher;
import org.zmlx.hg4idea.push.HgTarget;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgUtil;

public class HgPushSupport
extends PushSupport<HgRepository, HgPushSource, HgTarget> {
    @NotNull
    private final Project myProject;
    @NotNull
    private final HgVcs myVcs;
    @NotNull
    private final HgProjectSettings mySettings;
    @NotNull
    private final PushSettings myCommonPushSettings;

    public HgPushSupport(@NotNull Project project) {
        this.myProject = project;
        this.myVcs = Objects.requireNonNull(HgVcs.getInstance(this.myProject));
        this.mySettings = this.myVcs.getProjectSettings();
        this.myCommonPushSettings = (PushSettings)ServiceManager.getService((Project)project, PushSettings.class);
    }

    @NotNull
    public AbstractVcs getVcs() {
        return this.myVcs;
    }

    @NotNull
    public Pusher<HgRepository, HgPushSource, HgTarget> getPusher() {
        return new HgPusher();
    }

    @NotNull
    public OutgoingCommitsProvider<HgRepository, HgPushSource, HgTarget> getOutgoingCommitsProvider() {
        return new HgOutgoingCommitsProvider();
    }

    @Nullable
    public HgTarget getDefaultTarget(@NotNull HgRepository repository) {
        String defaultPushPath = repository.getRepositoryConfig().getDefaultPushPath();
        return defaultPushPath == null ? null : new HgTarget(defaultPushPath, Objects.requireNonNull(repository.getCurrentBranchName()));
    }

    @Nullable
    public HgTarget getDefaultTarget(@NotNull HgRepository repository, @NotNull HgPushSource source) {
        return this.getDefaultTarget(repository);
    }

    @NotNull
    public HgPushSource getSource(@NotNull HgRepository repository) {
        String localBranch = repository.getCurrentBranchName();
        assert (localBranch != null);
        return new HgPushSource(localBranch);
    }

    @NotNull
    public RepositoryManager<HgRepository> getRepositoryManager() {
        return HgUtil.getRepositoryManager(this.myProject);
    }

    @Nullable
    public VcsPushOptionsPanel createOptionsPanel() {
        return new HgPushOptionsPanel();
    }

    @NotNull
    public PushTargetPanel<HgTarget> createTargetPanel(@NotNull HgRepository repository, @NotNull HgPushSource source, @Nullable HgTarget defaultTarget) {
        return new HgPushTargetPanel(repository, source, defaultTarget);
    }

    public boolean isForcePushAllowed(@NotNull HgRepository repo, @NotNull HgTarget target) {
        return true;
    }

    public boolean shouldRequestIncomingChangesForNotCheckedRepositories() {
        return this.mySettings.getSyncSetting() == DvcsSyncSettings.Value.SYNC;
    }

    public void saveSilentForcePushTarget(@NotNull HgTarget target) {
        this.myCommonPushSettings.addForcePushTarget(target.getPresentation(), target.getBranchName());
    }

    public boolean isSilentForcePushAllowed(@NotNull HgTarget target) {
        return this.myCommonPushSettings.containsForcePushTarget(target.getPresentation(), target.getBranchName());
    }
}

