/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.execution;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Messages;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.execution.HgPromptChoice;
import org.zmlx.hg4idea.execution.HgPromptHandler;

public class HgDeleteModifyPromptHandler
implements HgPromptHandler {
    private static final Logger LOG = Logger.getInstance(HgDeleteModifyPromptHandler.class);
    private static final Pattern LOCAL_DELETE_REMOTE_MODIFIED_CONFLICT_MESSAGE_PATTERN = Pattern.compile("remote\\schanged(.+)which\\slocal\\sdeleted\\s.+");
    private static final Pattern REMOTE_DELETE_LOCAL_MODIFIED_CONFLICT_MESSAGE_PATTERN = Pattern.compile("\\slocal\\schanged(.+)which\\sremote\\sdeleted\\s.+");

    @Override
    public HgPromptChoice promptUser(@NotNull String message, HgPromptChoice @NotNull [] choices, @NotNull HgPromptChoice defaultChoice) {
        String modifiedMessage;
        Matcher localDelMatcher = LOCAL_DELETE_REMOTE_MODIFIED_CONFLICT_MESSAGE_PATTERN.matcher(message);
        Matcher localModifyMatcher = REMOTE_DELETE_LOCAL_MODIFIED_CONFLICT_MESSAGE_PATTERN.matcher(message);
        if (localDelMatcher.matches()) {
            String filename = localDelMatcher.group(1);
            modifiedMessage = HgBundle.message("hg4idea.delete.modify.file.deleted.locally", filename);
        } else if (localModifyMatcher.matches()) {
            String filename = localModifyMatcher.group(1);
            modifiedMessage = HgBundle.message("hg4idea.delete.modify.file.deleted.remotely", filename);
        } else {
            modifiedMessage = message;
        }
        int[] chosen = new int[]{-1};
        try {
            EventQueue.invokeAndWait(() -> {
                String[] choicePresentationArray = new String[choices.length];
                for (int i = 0; i < choices.length; ++i) {
                    choicePresentationArray[i] = choices[i].toString();
                }
                chosen[0] = Messages.showDialog((String)modifiedMessage, (String)HgBundle.message("hg4idea.delete.modify.conflict.title", new Object[0]), (String[])choicePresentationArray, (int)defaultChoice.getChosenIndex(), (Icon)Messages.getQuestionIcon());
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            LOG.error((Throwable)e);
            return defaultChoice;
        }
        return chosen[0] >= 0 ? choices[chosen[0]] : HgPromptChoice.ABORT;
    }

    @Override
    public boolean shouldHandle(@Nullable String message) {
        if (message == null) {
            return false;
        }
        Matcher localDelMatcher = LOCAL_DELETE_REMOTE_MODIFIED_CONFLICT_MESSAGE_PATTERN.matcher(message);
        Matcher localModifyMatcher = REMOTE_DELETE_LOCAL_MODIFIED_CONFLICT_MESSAGE_PATTERN.matcher(message);
        return localDelMatcher.matches() || localModifyMatcher.matches();
    }
}

