/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command.mq;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import java.util.Arrays;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.HgNameWithHashInfo;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgErrorUtil;
import org.zmlx.hg4idea.util.HgPatchReferenceValidator;

public class HgQRenameCommand {
    private static final Logger LOG = Logger.getInstance(HgQRenameCommand.class);
    @NotNull
    private final HgRepository myRepository;

    public HgQRenameCommand(@NotNull HgRepository repository) {
        this.myRepository = repository;
    }

    public void execute(@NotNull Hash patchHash) {
        Project project = this.myRepository.getProject();
        HgNameWithHashInfo patchInfo = (HgNameWithHashInfo)ContainerUtil.find(this.myRepository.getMQAppliedPatches(), info -> info.getHash().equals(patchHash));
        if (patchInfo == null) {
            LOG.error("Could not find patch " + patchHash.toString());
            return;
        }
        String oldName = patchInfo.getName();
        String newName = Messages.showInputDialog((Project)project, (String)HgBundle.message("action.hg4idea.QRename.enter.patch.name", oldName), (String)HgBundle.message("action.hg4idea.QRename.title", new Object[0]), (Icon)Messages.getQuestionIcon(), (String)"", (InputValidator)new HgPatchReferenceValidator(this.myRepository));
        if (newName != null) {
            HgQRenameCommand.performPatchRename(this.myRepository, oldName, newName);
        }
    }

    public static void performPatchRename(@NotNull HgRepository repository, @NotNull String oldName, @NotNull String newName) {
        if (oldName.equals(newName)) {
            return;
        }
        Project project = repository.getProject();
        BackgroundTaskUtil.executeOnPooledThread((Disposable)repository, () -> {
            HgCommandExecutor executor = new HgCommandExecutor(project);
            HgCommandResult result = executor.executeInCurrentThread(repository.getRoot(), "qrename", Arrays.asList(oldName, newName));
            if (HgErrorUtil.hasErrorsInCommandExecution(result)) {
                new HgCommandResultNotifier(project).notifyError(result, HgBundle.message("action.hg4idea.QRename.error", new Object[0]), HgBundle.message("action.hg4idea.QRename.error.msg", oldName, newName));
            }
            repository.update();
        });
    }
}

