/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.HgProjectSettings;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.command.HgChangesetsCommand;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.HgRemoteCommandExecutor;
import org.zmlx.hg4idea.util.HgErrorUtil;
import org.zmlx.hg4idea.util.HgUtil;

public abstract class HgRemoteChangesetsCommand
extends HgChangesetsCommand {
    private static final Logger LOG = Logger.getInstance(HgRemoteChangesetsCommand.class);

    public HgRemoteChangesetsCommand(Project project, String command) {
        super(project, command);
    }

    @Override
    protected void addArguments(List<String> args) {
        args.add("--newest-first");
    }

    @Override
    protected boolean isSilentCommand() {
        return true;
    }

    @Nullable
    protected String getRepositoryUrl(VirtualFile root) {
        return HgUtil.getRepositoryDefaultPath(this.project, root);
    }

    @Override
    protected HgCommandResult executeCommandInCurrentThread(VirtualFile repo, List<String> args) {
        String repositoryURL = this.getRepositoryUrl(repo);
        if (repositoryURL == null) {
            LOG.info("executeCommand no default path configured");
            return null;
        }
        HgRemoteCommandExecutor executor = new HgRemoteCommandExecutor(this.project, repositoryURL);
        HgCommandResult result = executor.executeInCurrentThread(repo, this.command, args);
        if (result == HgCommandResult.CANCELLED || HgErrorUtil.isAuthorizationError(result)) {
            final HgVcs vcs = HgVcs.getInstance(this.project);
            if (vcs == null) {
                return result;
            }
            new HgCommandResultNotifier(this.project).notifyError(result, HgBundle.message("hg4idea.changesets.error", new Object[0]), HgBundle.message("hg4idea.changesets.error.msg", repositoryURL), new NotificationListener(){

                public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    ShowSettingsUtil.getInstance().showSettingsDialog(HgRemoteChangesetsCommand.this.project, vcs.getConfigurable().getDisplayName());
                }
            });
            HgProjectSettings projectSettings = vcs.getProjectSettings();
            projectSettings.setCheckIncomingOutgoing(false);
        }
        return result;
    }
}

